/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.impl.hotupdate;

import java.io.File;

public class LastModifiedTracker {
    private File targetFile;
    private Long lastModified;

    public LastModifiedTracker(File targetFile) {
        this.targetFile = targetFile;
        this.checkModified();
    }

    public void reset() {
        this.lastModified = null;
    }

    public boolean checkModified() {
        long newLastModified = this.getNewLastModified(this.targetFile);
        if (this.lastModified == null) {
            this.lastModified = newLastModified;
            return false;
        }
        if (newLastModified > this.lastModified) {
            this.lastModified = newLastModified;
            return true;
        }
        return false;
    }

    protected long getNewLastModified(File f) {
        if (!f.exists()) {
            return 0L;
        }
        if (f.isFile()) {
            return f.lastModified();
        }
        long newLastModified = f.lastModified();
        for (File fx : f.listFiles()) {
            long fxLastModified = this.getNewLastModified(fx);
            if (fxLastModified <= newLastModified) continue;
            newLastModified = fxLastModified;
        }
        return newLastModified;
    }
}

