/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.definitions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.definitions.SCADefinitionsBuilder;
import org.apache.tuscany.sca.definitions.SCADefinitionsBuilderException;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.ProfileIntent;
import org.apache.tuscany.sca.policy.QualifiedIntent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCADefinitionsBuilderImpl
implements SCADefinitionsBuilder {
    @Override
    public void build(SCADefinitions scaDefns) throws SCADefinitionsBuilderException {
        HashMap<QName, Intent> definedIntents = new HashMap<QName, Intent>();
        for (Intent intent : scaDefns.getPolicyIntents()) {
            definedIntents.put(intent.getName(), intent);
        }
        HashMap<QName, PolicySet> definedPolicySets = new HashMap<QName, PolicySet>();
        for (PolicySet policySet : scaDefns.getPolicySets()) {
            definedPolicySets.put(policySet.getName(), policySet);
        }
        HashMap<QName, IntentAttachPointType> definedBindingTypes = new HashMap<QName, IntentAttachPointType>();
        for (IntentAttachPointType bindingType : scaDefns.getBindingTypes()) {
            definedBindingTypes.put(bindingType.getName(), bindingType);
        }
        HashMap<QName, IntentAttachPointType> definedImplTypes = new HashMap<QName, IntentAttachPointType>();
        for (IntentAttachPointType implType : scaDefns.getImplementationTypes()) {
            definedImplTypes.put(implType.getName(), implType);
        }
        scaDefns.getPolicyIntents().clear();
        scaDefns.getPolicySets().clear();
        scaDefns.getBindingTypes().clear();
        scaDefns.getImplementationTypes().clear();
        scaDefns.getPolicyIntents().addAll(definedIntents.values());
        scaDefns.getPolicySets().addAll(definedPolicySets.values());
        scaDefns.getBindingTypes().addAll(definedBindingTypes.values());
        scaDefns.getImplementationTypes().addAll(definedImplTypes.values());
        this.buildPolicyIntents(scaDefns, definedIntents);
        this.buildPolicySets(scaDefns, definedPolicySets, definedIntents);
        this.buildBindingTypes(scaDefns, definedBindingTypes, definedIntents);
        this.buildImplementationTypes(scaDefns, definedImplTypes, definedIntents);
    }

    private void buildBindingTypes(SCADefinitions scaDefns, Map<QName, IntentAttachPointType> definedBindingTypes, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        for (IntentAttachPointType bindingType : scaDefns.getBindingTypes()) {
            this.buildAlwaysProvidedIntents(bindingType, definedIntents);
            this.buildMayProvideIntents(bindingType, definedIntents);
        }
    }

    private void buildImplementationTypes(SCADefinitions scaDefns, Map<QName, IntentAttachPointType> definedImplTypes, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        for (IntentAttachPointType implType : scaDefns.getImplementationTypes()) {
            this.buildAlwaysProvidedIntents(implType, definedIntents);
            this.buildMayProvideIntents(implType, definedIntents);
        }
    }

    private void buildPolicyIntents(SCADefinitions scaDefns, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        for (Intent policyIntent : scaDefns.getPolicyIntents()) {
            if (policyIntent instanceof ProfileIntent) {
                this.buildProfileIntent((ProfileIntent)policyIntent, definedIntents);
            }
            if (!(policyIntent instanceof QualifiedIntent)) continue;
            this.buildQualifiedIntent((QualifiedIntent)policyIntent, definedIntents);
        }
    }

    private void buildPolicySets(SCADefinitions scaDefns, Map<QName, PolicySet> definedPolicySets, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        for (PolicySet policySet : scaDefns.getPolicySets()) {
            this.buildProvidedIntents(policySet, definedIntents);
            this.buildIntentsInMappedPolicies(policySet, definedIntents);
            this.buildReferredPolicySets(policySet, definedPolicySets);
        }
        for (PolicySet policySet : scaDefns.getPolicySets()) {
            for (PolicySet referredPolicySet : policySet.getReferencedPolicySets()) {
                this.includeReferredPolicySets(policySet, referredPolicySet);
            }
        }
    }

    private void buildProfileIntent(ProfileIntent policyIntent, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        if (policyIntent != null) {
            ArrayList<Intent> requiredIntents = new ArrayList<Intent>();
            for (Intent requiredIntent : policyIntent.getRequiredIntents()) {
                if (requiredIntent.isUnresolved()) {
                    Intent resolvedRequiredIntent = definedIntents.get(requiredIntent.getName());
                    if (resolvedRequiredIntent != null) {
                        requiredIntents.add(resolvedRequiredIntent);
                        continue;
                    }
                    throw new SCADefinitionsBuilderException("Required Intent - " + requiredIntent + " not found for ProfileIntent " + policyIntent);
                }
                requiredIntents.add(requiredIntent);
            }
            policyIntent.getRequiredIntents().clear();
            policyIntent.getRequiredIntents().addAll(requiredIntents);
        }
    }

    private void buildQualifiedIntent(QualifiedIntent policyIntent, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        Intent qualifiableIntent;
        if (policyIntent != null && (qualifiableIntent = policyIntent.getQualifiableIntent()).isUnresolved()) {
            Intent resolvedQualifiableIntent = definedIntents.get(qualifiableIntent.getName());
            if (resolvedQualifiableIntent != null) {
                policyIntent.setQualifiableIntent(resolvedQualifiableIntent);
            } else {
                throw new SCADefinitionsBuilderException("Qualifiable Intent - " + qualifiableIntent + " not found for QualifiedIntent " + policyIntent);
            }
        }
    }

    private void buildAlwaysProvidedIntents(IntentAttachPointType extensionType, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        if (extensionType != null) {
            ArrayList<Intent> alwaysProvided = new ArrayList<Intent>();
            for (Intent providedIntent : extensionType.getAlwaysProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    Intent resolvedProvidedIntent = definedIntents.get(providedIntent.getName());
                    if (resolvedProvidedIntent != null) {
                        alwaysProvided.add(resolvedProvidedIntent);
                        continue;
                    }
                    throw new SCADefinitionsBuilderException("Always Provided Intent - " + providedIntent + " not found for ExtensionType " + extensionType);
                }
                alwaysProvided.add(providedIntent);
            }
            extensionType.getAlwaysProvidedIntents().clear();
            extensionType.getAlwaysProvidedIntents().addAll(alwaysProvided);
        }
    }

    private void buildMayProvideIntents(IntentAttachPointType extensionType, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        if (extensionType != null) {
            ArrayList<Intent> mayProvide = new ArrayList<Intent>();
            for (Intent providedIntent : extensionType.getMayProvideIntents()) {
                if (providedIntent.isUnresolved()) {
                    Intent resolvedProvidedIntent = definedIntents.get(providedIntent.getName());
                    if (resolvedProvidedIntent != null) {
                        mayProvide.add(resolvedProvidedIntent);
                        continue;
                    }
                    throw new SCADefinitionsBuilderException("May Provide Intent - " + providedIntent + " not found for ExtensionType " + extensionType);
                }
                mayProvide.add(providedIntent);
            }
            extensionType.getMayProvideIntents().clear();
            extensionType.getMayProvideIntents().addAll(mayProvide);
        }
    }

    private void buildProvidedIntents(PolicySet policySet, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        if (policySet != null) {
            ArrayList<Intent> providedIntents = new ArrayList<Intent>();
            for (Intent providedIntent : policySet.getProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    Intent resolvedProvidedIntent = definedIntents.get(providedIntent.getName());
                    if (resolvedProvidedIntent != null) {
                        providedIntents.add(resolvedProvidedIntent);
                        continue;
                    }
                    throw new SCADefinitionsBuilderException("Provided Intent - " + providedIntent + " not found for PolicySet " + policySet);
                }
                providedIntents.add(providedIntent);
            }
            policySet.getProvidedIntents().clear();
            policySet.getProvidedIntents().addAll(providedIntents);
        }
    }

    private void buildIntentsInMappedPolicies(PolicySet policySet, Map<QName, Intent> definedIntents) throws SCADefinitionsBuilderException {
        Hashtable mappedPolicies = new Hashtable();
        for (Map.Entry entry : policySet.getMappedPolicies().entrySet()) {
            Intent mappedIntent = (Intent)entry.getKey();
            if (mappedIntent.isUnresolved()) {
                Intent resolvedMappedIntent = definedIntents.get(mappedIntent.getName());
                if (resolvedMappedIntent != null) {
                    mappedPolicies.put(resolvedMappedIntent, entry.getValue());
                    continue;
                }
                throw new SCADefinitionsBuilderException("Mapped Intent - " + mappedIntent + " not found for PolicySet " + policySet);
            }
            mappedPolicies.put(mappedIntent, entry.getValue());
        }
        policySet.getMappedPolicies().clear();
        policySet.getMappedPolicies().putAll(mappedPolicies);
    }

    private void buildReferredPolicySets(PolicySet policySet, Map<QName, PolicySet> definedPolicySets) throws SCADefinitionsBuilderException {
        ArrayList<PolicySet> referredPolicySets = new ArrayList<PolicySet>();
        for (PolicySet referredPolicySet : policySet.getReferencedPolicySets()) {
            if (referredPolicySet.isUnresolved()) {
                PolicySet resolvedReferredPolicySet = definedPolicySets.get(referredPolicySet.getName());
                if (resolvedReferredPolicySet != null) {
                    referredPolicySets.add(resolvedReferredPolicySet);
                    continue;
                }
                throw new SCADefinitionsBuilderException("Referred PolicySet - " + referredPolicySet + "not found for PolicySet - " + policySet);
            }
            referredPolicySets.add(referredPolicySet);
        }
        policySet.getReferencedPolicySets().clear();
        policySet.getReferencedPolicySets().addAll(referredPolicySets);
    }

    private void includeReferredPolicySets(PolicySet policySet, PolicySet referredPolicySet) {
        for (PolicySet furtherReferredPolicySet : referredPolicySet.getReferencedPolicySets()) {
            this.includeReferredPolicySets(referredPolicySet, furtherReferredPolicySet);
        }
        policySet.getPolicies().addAll(referredPolicySet.getPolicies());
        policySet.getMappedPolicies().putAll(referredPolicySet.getMappedPolicies());
    }
}

