/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resource.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resource.ResourceImport;
import org.apache.tuscany.sca.contribution.resource.ResourceImportExportFactory;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class ResourceImportProcessor
implements StAXArtifactProcessor<ResourceImport> {
    private static final String URI = "uri";
    private static final String LOCATION = "location";
    private final ResourceImportExportFactory factory;

    public ResourceImportProcessor(FactoryExtensionPoint modelFactories) {
        this.factory = (ResourceImportExportFactory)modelFactories.getFactory(ResourceImportExportFactory.class);
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-resource-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    public QName getArtifactType() {
        return ResourceImport.TYPE;
    }

    public Class<ResourceImport> getModelType() {
        return ResourceImport.class;
    }

    public ResourceImport read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException {
        ResourceImport resourceImport = this.factory.createResourceImport();
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        QName element = reader.getName();
                        if (!ResourceImport.TYPE.equals(element)) break;
                        String uri = reader.getAttributeValue(null, URI);
                        if (uri == null) {
                            this.error(context.getMonitor(), "AttributeURIMissing", reader, new Object[0]);
                        } else {
                            resourceImport.setURI(uri);
                        }
                        String location = reader.getAttributeValue(null, LOCATION);
                        if (location == null) break;
                        resourceImport.setLocation(location);
                        break;
                    }
                    case 2: {
                        if (!ResourceImport.TYPE.equals(reader.getName())) break;
                        return resourceImport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error(context.getMonitor(), "XMLStreamException", reader, ex);
        }
        return resourceImport;
    }

    public void write(ResourceImport resourceImport, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(ResourceImport.TYPE.getNamespaceURI(), ResourceImport.TYPE.getLocalPart());
        if (resourceImport.getURI() != null) {
            writer.writeAttribute(URI, resourceImport.getURI());
        }
        if (resourceImport.getLocation() != null) {
            writer.writeAttribute(LOCATION, resourceImport.getLocation());
        }
        writer.writeEndElement();
    }

    public void resolve(ResourceImport model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

