/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resource.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resource.ResourceImport;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class ArtifactModelResolver
implements ModelResolver {
    private Contribution contribution;
    private Map<String, Artifact> map = new HashMap<String, Artifact>();

    public ArtifactModelResolver(Contribution contribution, FactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    public void addModel(Object resolved, ProcessorContext context) {
        Artifact artifact = (Artifact)resolved;
        this.map.put(artifact.getURI(), artifact);
    }

    public Object removeModel(Object resolved, ProcessorContext context) {
        return this.map.remove(((Artifact)resolved).getURI());
    }

    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        String uri = ((Artifact)unresolved).getURI();
        if (uri == null) {
            return unresolved;
        }
        Artifact resolved = this.map.get(uri);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        for (Import import_ : this.contribution.getImports()) {
            ResourceImport resourceImport;
            if (!(import_ instanceof ResourceImport) || !(resourceImport = (ResourceImport)import_).getURI().equals(uri) || resourceImport.getModelResolver() == null || (resolved = (Artifact)resourceImport.getModelResolver().resolveModel(Artifact.class, (Object)((Artifact)unresolved), context)).isUnresolved()) continue;
            return modelClass.cast(resolved);
        }
        return unresolved;
    }
}

