/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resource.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resource.ResourceImport;
import org.apache.tuscany.sca.contribution.resource.ResourceImportExportFactory;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImportProcessor
implements StAXArtifactProcessor<ResourceImport> {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final QName IMPORT_RESOURCE = new QName("http://www.osoa.org/xmlns/sca/1.0", "import.resource");
    private static final String URI = "uri";
    private static final String LOCATION = "location";
    private final ResourceImportExportFactory factory;
    private final Monitor monitor;

    public ResourceImportProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.factory = (ResourceImportExportFactory)modelFactories.getFactory(ResourceImportExportFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-resource-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-resource-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    public QName getArtifactType() {
        return IMPORT_RESOURCE;
    }

    public Class<ResourceImport> getModelType() {
        return ResourceImport.class;
    }

    public ResourceImport read(XMLStreamReader reader) throws ContributionReadException {
        ResourceImport resourceImport = this.factory.createResourceImport();
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        QName element = reader.getName();
                        if (!IMPORT_RESOURCE.equals(element)) break;
                        String uri = reader.getAttributeValue(null, URI);
                        if (uri == null) {
                            this.error("AttributeURIMissing", (Object)reader, new Object[0]);
                        } else {
                            resourceImport.setURI(uri);
                        }
                        String location = reader.getAttributeValue(null, LOCATION);
                        if (location == null) break;
                        resourceImport.setLocation(location);
                        break;
                    }
                    case 2: {
                        if (!IMPORT_RESOURCE.equals(reader.getName())) break;
                        return resourceImport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("XMLStreamException", (Object)reader, (Exception)ex);
        }
        return resourceImport;
    }

    public void write(ResourceImport resourceImport, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(IMPORT_RESOURCE.getNamespaceURI(), IMPORT_RESOURCE.getLocalPart());
        if (resourceImport.getURI() != null) {
            writer.writeAttribute(URI, resourceImport.getURI());
        }
        if (resourceImport.getLocation() != null) {
            writer.writeAttribute(LOCATION, resourceImport.getLocation());
        }
        writer.writeEndElement();
    }

    public void resolve(ResourceImport model, ModelResolver resolver) throws ContributionResolveException {
    }
}

