/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.security.http.ssl;

import java.util.logging.Logger;
import org.apache.tuscany.sca.binding.ws.axis2.provider.Axis2BaseBindingProvider;
import org.apache.tuscany.sca.host.http.SecurityContext;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.policy.security.http.ssl.HTTPSPolicy;
import org.apache.tuscany.sca.provider.BasePolicyProvider;

public class HTTPSPolicyProvider
extends BasePolicyProvider<HTTPSPolicy> {
    private final Logger logger = Logger.getLogger(HTTPSPolicyProvider.class.getName());

    public HTTPSPolicyProvider(PolicySubject subject) {
        super(HTTPSPolicy.class, subject);
    }

    public void configureBinding(Object context) {
        SecurityContext securityContext = ((Axis2BaseBindingProvider)context).getHttpSecurityContext();
        for (HTTPSPolicy policy : this.findPolicies()) {
            if (!(policy instanceof HTTPSPolicy)) continue;
            HTTPSPolicy httpsPolicy = policy;
            securityContext.setSSLEnabled(true);
            securityContext.setSSLProperties(httpsPolicy.toProperties());
            this.logger.info("HTTPSPolicyProvider: Setting JVM trust store to " + httpsPolicy.getTrustStore());
            System.setProperty("javax.net.ssl.trustStore", httpsPolicy.getTrustStore());
            System.setProperty("javax.net.ssl.trustStorePassword", httpsPolicy.getTrustStorePassword());
            System.setProperty("javax.net.ssl.trustStoreType", httpsPolicy.getTrustStoreType());
            this.logger.info("HTTPSPolicyProvider: Setting JVM key store to " + httpsPolicy.getKeyStore());
            System.setProperty("javax.net.ssl.keyStore", httpsPolicy.getKeyStore());
            System.setProperty("javax.net.ssl.keyStorePassword", httpsPolicy.getKeyStorePassword());
            System.setProperty("javax.net.ssl.keyStoreType", httpsPolicy.getKeyStoreType());
            return;
        }
    }
}

