/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.wsdl.WSDL11ActionHelper;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class Axis2ReferenceBindingInvoker
implements Invoker {
    public static final QName QNAME_WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From", "wsa");
    public static final QName QNAME_WSA_ACTION = new QName("http://www.w3.org/2005/08/addressing", "Action", "wsa");
    private RuntimeEndpointReference endpointReference;
    private ServiceClient serviceClient;
    private QName wsdlOperationName;
    private Options options;
    private SOAPFactory soapFactory;
    private WebServiceBinding wsBinding;

    public Axis2ReferenceBindingInvoker(RuntimeEndpointReference endpointReference, ServiceClient serviceClient, QName wsdlOperationName, Options options, SOAPFactory soapFactory, WebServiceBinding wsBinding) {
        this.endpointReference = endpointReference;
        this.serviceClient = serviceClient;
        this.wsdlOperationName = wsdlOperationName;
        this.options = options;
        this.soapFactory = soapFactory;
        this.wsBinding = wsBinding;
    }

    public Message invoke(Message msg) {
        try {
            OperationClient operationClient = this.createOperationClient(msg);
            msg.setBindingContext((Object)operationClient);
            msg = this.endpointReference.getBindingInvocationChain().getHeadInvoker().invoke(msg);
        }
        catch (AxisFault e) {
            if (e.getDetail() != null) {
                FaultException f = new FaultException(e.getMessage(), (Object)e.getDetail(), (Throwable)e);
                f.setFaultName(e.getDetail().getQName());
                msg.setFaultBody((Object)f);
            } else {
                msg.setFaultBody((Object)e);
            }
        }
        catch (Throwable e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OperationClient createOperationClient(Message msg) throws AxisFault {
        SOAPEnvelope env = this.soapFactory.getDefaultEnvelope();
        Object[] args = (Object[])msg.getBody();
        if (args != null && args.length > 0) {
            SOAPBody body = env.getBody();
            for (Object bc : args) {
                if (!(bc instanceof OMElement)) {
                    throw new IllegalArgumentException("Can't handle mixed payloads between OMElements and other types.");
                }
                body.addChild((OMNode)((OMElement)bc));
            }
        }
        final MessageContext requestMC = new MessageContext();
        requestMC.setEnvelope(env);
        final OperationClient operationClient = this.serviceClient.createClient(this.wsdlOperationName);
        operationClient.setOptions(this.options);
        Endpoint callbackEndpoint = msg.getFrom().getCallbackEndpoint();
        if (callbackEndpoint != null) {
            EndpointReference fromEPR = new EndpointReference(callbackEndpoint.getURI());
            SOAPEnvelope sev = requestMC.getEnvelope();
            SOAPHeader sh = sev.getHeader();
            OMElement epr = EndpointReferenceHelper.toOM((OMFactory)sev.getOMFactory(), (EndpointReference)fromEPR, (QName)QNAME_WSA_FROM, (String)"http://www.w3.org/2005/08/addressing");
            sh.addChild((OMNode)epr);
            String action = this.options.getAction();
            if (action == null) {
                PortType portType = ((WSDLInterface)this.wsBinding.getBindingInterfaceContract().getInterface()).getPortType();
                Operation op = portType.getOperation(this.wsdlOperationName.getLocalPart(), null, null);
                action = WSDL11ActionHelper.getActionFromInputElement((Definition)this.wsBinding.getWSDLDocument(), (PortType)portType, (Operation)op, (Input)op.getInput());
            }
            OMElement actionOM = sev.getOMFactory().createOMElement(QNAME_WSA_ACTION);
            actionOM.setText(action == null ? "" : action);
            sh.addChild((OMNode)actionOM);
            requestMC.setFrom(fromEPR);
        }
        if (this.options.getTo() == null) {
            Endpoint ep = msg.getTo();
            if (ep == null || ep.getBinding() == null) throw new ServiceRuntimeException("Unable to determine destination endpoint");
            requestMC.setTo(new EndpointReference(ep.getBinding().getURI()));
        } else {
            requestMC.setTo(new EndpointReference(this.options.getTo().getAddress()));
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AxisFault {
                    operationClient.addMessageContext(requestMC);
                    return null;
                }
            });
            return operationClient;
        }
        catch (PrivilegedActionException e) {
            throw (AxisFault)((Object)e.getException());
        }
    }
}

