/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.axis2.impl;

import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.binding.sca.DistributedSCABinding;
import org.apache.tuscany.sca.binding.sca.axis2.impl.Axis2SCABindingInvoker;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ReferenceBindingProvider;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2SCAReferenceBindingProvider
implements ReferenceBindingProvider {
    private static final Logger logger = Logger.getLogger(Axis2SCAReferenceBindingProvider.class.getName());
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private SCABinding binding;
    private Axis2ReferenceBindingProvider axisReferenceBindingProvider;
    private WebServiceBinding wsBinding;
    private EndpointReference serviceEPR = null;
    private EndpointReference callbackEPR = null;

    public Axis2SCAReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, DistributedSCABinding binding, ExtensionPointRegistry extensionPoints, List<PolicyHandlerTuple> policyHandlerClassnames) {
        ServletHostExtensionPoint servletHosts = (ServletHostExtensionPoint)extensionPoints.getExtensionPoint(ServletHostExtensionPoint.class);
        ServletHost servletHost = (ServletHost)servletHosts.getServletHosts().get(0);
        ModelFactoryExtensionPoint modelFactories = (ModelFactoryExtensionPoint)extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        DataBindingExtensionPoint dataBindings = (DataBindingExtensionPoint)extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
        this.component = component;
        this.reference = reference;
        this.binding = binding.getSCABinding();
        this.wsBinding = ((WebServiceBindingFactory)modelFactories.getFactory(WebServiceBindingFactory.class)).createWebServiceBinding();
        this.wsBinding.setName(this.binding.getName());
        BindingWSDLGenerator.generateWSDL((Component)component, (AbstractContract)reference, (WebServiceBinding)this.wsBinding, (ExtensionPointRegistry)extensionPoints, null);
        InterfaceContract contract = this.wsBinding.getBindingInterfaceContract();
        contract.getInterface().resetDataBinding(OMElement.class.getName());
        this.axisReferenceBindingProvider = new Axis2ReferenceBindingProvider(component, reference, this.wsBinding, modelFactories, policyHandlerClassnames, dataBindings);
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.wsBinding.getBindingInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public Invoker createInvoker(Operation operation) {
        return new Axis2SCABindingInvoker(this, this.axisReferenceBindingProvider.createInvoker(operation));
    }

    public EndpointReference getServiceEndpoint() {
        if (this.serviceEPR == null) {
            String endpointURL = null;
            if (this.binding.getURI() != null) {
                try {
                    URI uri = new URI(this.binding.getURI());
                    if (uri.isAbsolute()) {
                        endpointURL = this.binding.getURI();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.serviceEPR = new EndpointReferenceImpl(endpointURL);
        }
        return this.serviceEPR;
    }

    public EndpointReference getCallbackEndpoint() {
        if (this.callbackEPR == null && this.reference.getCallbackService() != null) {
            for (Binding callbackBinding : this.reference.getCallbackService().getBindings()) {
                if (!(callbackBinding instanceof SCABinding)) continue;
                this.callbackEPR = new EndpointReferenceImpl(this.reference.getName() + "/" + callbackBinding.getName());
            }
        }
        return this.callbackEPR;
    }

    public SCABinding getSCABinding() {
        return this.binding;
    }

    public RuntimeComponent getComponent() {
        return this.component;
    }

    public RuntimeComponentReference getComponentReference() {
        return this.reference;
    }

    public void start() {
        this.axisReferenceBindingProvider.start();
    }

    public void stop() {
        this.axisReferenceBindingProvider.stop();
    }
}

