/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import java.util.List;
import javax.servlet.Servlet;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.provider.HTTPBindingListenerServlet;
import org.apache.tuscany.sca.binding.http.provider.HTTPRRBListenerServlet;
import org.apache.tuscany.sca.binding.http.provider.HTTPServiceListenerServlet;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.host.http.SecurityContext;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.authentication.AuthenticationConfigurationPolicy;
import org.apache.tuscany.sca.policy.confidentiality.ConfidentialityPolicy;
import org.apache.tuscany.sca.provider.OperationSelectorProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ServiceBindingProviderRRB;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class HTTPServiceBindingProvider
implements ServiceBindingProviderRRB {
    private static final QName AUTEHTICATION_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "authentication");
    private static final QName CONFIDENTIALITY_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "confidentiality");
    private ExtensionPointRegistry extensionPoints;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private InterfaceContract serviceContract;
    private HTTPBinding binding;
    private MessageFactory messageFactory;
    private OperationSelectorProvider osProvider;
    private WireFormatProvider wfProvider;
    private ServletHost servletHost;
    private String servletMapping;
    private HTTPBindingListenerServlet bindingListenerServlet;

    public HTTPServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, HTTPBinding binding, ExtensionPointRegistry extensionPoints, MessageFactory messageFactory, ServletHost servletHost) {
        WireFormatProviderFactory wfProviderFactory;
        OperationSelectorProviderFactory osProviderFactory;
        this.component = component;
        this.service = service;
        this.binding = binding;
        this.extensionPoints = extensionPoints;
        this.messageFactory = messageFactory;
        this.servletHost = servletHost;
        ProviderFactoryExtensionPoint providerFactories = (ProviderFactoryExtensionPoint)extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        if (binding.getOperationSelector() != null && (osProviderFactory = (OperationSelectorProviderFactory)providerFactories.getProviderFactory(binding.getOperationSelector().getClass())) != null) {
            this.osProvider = osProviderFactory.createServiceOperationSelectorProvider(component, service, (Binding)binding);
        }
        if (binding.getRequestWireFormat() != null && binding.getResponseWireFormat() != null && (wfProviderFactory = (WireFormatProviderFactory)providerFactories.getProviderFactory(binding.getRequestWireFormat().getClass())) != null) {
            this.wfProvider = wfProviderFactory.createServiceWireFormatProvider(component, service, (Binding)binding);
        }
        try {
            this.serviceContract = (InterfaceContract)service.getInterfaceContract().clone();
            if (this.wfProvider != null) {
                this.wfProvider.configureWireFormatInterfaceContract(service.getInterfaceContract());
            }
        }
        catch (CloneNotSupportedException e) {
            this.serviceContract = service.getInterfaceContract();
        }
    }

    public void start() {
        RuntimeComponentService componentService = this.service;
        RuntimeWire wire = componentService.getRuntimeWire((Binding)this.binding);
        Object servlet = null;
        this.bindingListenerServlet = new HTTPBindingListenerServlet((Binding)this.binding, this.messageFactory);
        for (InvocationChain invocationChain : wire.getInvocationChains()) {
            Operation operation = invocationChain.getTargetOperation();
            String operationName = operation.getName();
            if (operationName.equals("get")) {
                Invoker getInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setGetInvoker(getInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalGet")) {
                Invoker conditionalGetInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalGetInvoker(conditionalGetInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("delete")) {
                Invoker deleteInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setDeleteInvoker(deleteInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalDelete")) {
                Invoker conditionalDeleteInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalDeleteInvoker(conditionalDeleteInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("put")) {
                Invoker putInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setPutInvoker(putInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPut")) {
                Invoker conditionalPutInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalPutInvoker(conditionalPutInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("post")) {
                Invoker postInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setPostInvoker(postInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPost")) {
                Invoker conditionalPostInvoker = invocationChain.getHeadInvoker();
                this.bindingListenerServlet.setConditionalPostInvoker(conditionalPostInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("service")) {
                Invoker serviceInvoker = invocationChain.getHeadInvoker();
                servlet = new HTTPServiceListenerServlet((Binding)this.binding, serviceInvoker, this.messageFactory);
                break;
            }
            if (this.binding.getOperationSelector() == null && this.binding.getRequestWireFormat() == null) continue;
            Invoker bindingInvoker = wire.getBindingInvocationChain().getHeadInvoker();
            servlet = new HTTPRRBListenerServlet((Binding)this.binding, bindingInvoker, this.messageFactory);
            break;
        }
        if (servlet == null) {
            throw new IllegalStateException("No get or service method found on the service");
        }
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
        SecurityContext securityContext = new SecurityContext();
        boolean isConfidentialityRequired = false;
        boolean isAuthenticationRequired = false;
        if (this.binding instanceof PolicySetAttachPoint) {
            List intents = ((PolicySetAttachPoint)this.binding).getRequiredIntents();
            for (Intent intent : intents) {
                if (intent.getName().equals(AUTEHTICATION_INTENT)) {
                    isAuthenticationRequired = true;
                    continue;
                }
                if (!intent.getName().equals(CONFIDENTIALITY_INTENT)) continue;
                isConfidentialityRequired = true;
            }
            List policySets = ((PolicySetAttachPoint)this.binding).getApplicablePolicySets();
            for (PolicySet ps : policySets) {
                for (Object p : ps.getPolicies()) {
                    if (ConfidentialityPolicy.class.isInstance(p) && isConfidentialityRequired) {
                        ConfidentialityPolicy confidentialityPolicy = (ConfidentialityPolicy)p;
                        securityContext.setSSLEnabled(true);
                        securityContext.setSSLProperties(confidentialityPolicy.toProperties());
                        continue;
                    }
                    if (!AuthenticationConfigurationPolicy.class.isInstance(p) || !isAuthenticationRequired) continue;
                    AuthenticationConfigurationPolicy authenticationConfiguration = (AuthenticationConfigurationPolicy)p;
                    securityContext.setAuthenticationEnabled(true);
                    securityContext.getUsers().clear();
                    securityContext.getUsers().addAll(authenticationConfiguration.getUsers());
                }
            }
        }
        this.servletHost.addServletMapping(this.servletMapping, (Servlet)servlet, securityContext);
    }

    public void stop() {
        this.servletHost.removeServletMapping(this.servletMapping);
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void configureBindingChain(RuntimeWire runtimeWire) {
        InvocationChain bindingChain = runtimeWire.getBindingInvocationChain();
        if (this.osProvider != null) {
            bindingChain.addInterceptor("service.binding.operationselector", this.osProvider.createInterceptor());
        }
        if (this.wfProvider != null) {
            bindingChain.addInterceptor("service.binding.wireformat", this.wfProvider.createInterceptor());
        }
    }
}

