/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSignSAMLEnvelope
extends WSSignEnvelope {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$saml$WSSignSAMLEnvelope == null ? (class$org$apache$ws$security$saml$WSSignSAMLEnvelope = WSSignSAMLEnvelope.class$("org.apache.ws.security.saml.WSSignSAMLEnvelope")) : class$org$apache$ws$security$saml$WSSignSAMLEnvelope).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    static /* synthetic */ Class class$org$apache$ws$security$saml$WSSignSAMLEnvelope;

    public WSSignSAMLEnvelope() {
    }

    public WSSignSAMLEnvelope(String actor, boolean mu) {
        super(actor, mu);
    }

    public Document build(Document doc, Crypto userCrypto, SAMLAssertion assertion, Crypto issuerCrypto, String issuerKeyName, String issuerKeyPW) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (this.doDebug) {
            log.debug((Object)"Beginning ST signing...");
        }
        SAMLSubjectStatement samlSubjS = null;
        Iterator it = assertion.getStatements();
        while (it.hasNext()) {
            SAMLObject so = (SAMLObject)it.next();
            if (!(so instanceof SAMLSubjectStatement)) continue;
            samlSubjS = (SAMLSubjectStatement)so;
            break;
        }
        SAMLSubject samlSubj = null;
        if (samlSubjS != null) {
            samlSubj = samlSubjS.getSubject();
        }
        if (samlSubj == null) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature"});
        }
        String confirmMethod = null;
        it = samlSubj.getConfirmationMethods();
        if (it.hasNext()) {
            confirmMethod = (String)it.next();
        }
        boolean senderVouches = false;
        if ("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches".equals(confirmMethod)) {
            senderVouches = true;
        }
        WSDocInfo wsDocInfo = new WSDocInfo(doc.hashCode());
        Element envelope = doc.getDocumentElement();
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(envelope);
        Element securityHeader = this.insertSecurityHeader(doc);
        X509Certificate[] certs = null;
        if (senderVouches) {
            certs = issuerCrypto.getCertificates(issuerKeyName);
            wsDocInfo.setCrypto(issuerCrypto);
        } else {
            if (userCrypto == null || !assertion.isSigned()) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"for SAML Signature (Key Holder)"});
            }
            Element e = samlSubj.getKeyInfo();
            try {
                KeyInfo ki = new KeyInfo(e, null);
                if (ki.containsX509Data()) {
                    X509Data data = ki.itemX509Data(0);
                    XMLX509Certificate certElem = null;
                    if (data != null && data.containsCertificate()) {
                        certElem = data.itemCertificate(0);
                    }
                    if (certElem != null) {
                        X509Certificate cert = certElem.getX509Certificate();
                        certs = new X509Certificate[]{cert};
                    }
                }
            }
            catch (XMLSecurityException e3) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"}, e3);
            }
            wsDocInfo.setCrypto(userCrypto);
        }
        if (certs == null || certs.length <= 0) {
            throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Signature"});
        }
        if (this.sigAlgo == null) {
            String pubKeyAlgo = certs[0].getPublicKey().getAlgorithm();
            log.debug((Object)("automatic sig algo detection: " + pubKeyAlgo));
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else {
                throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Signature - unkown public key Algo"});
            }
        }
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(doc, null, this.sigAlgo, this.canonAlgo);
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(10, "noXMLSig");
        }
        KeyInfo info = sig.getKeyInfo();
        String keyInfoUri = "KeyId-" + info.hashCode();
        info.setId(keyInfoUri);
        SecurityTokenReference secRef = new SecurityTokenReference(doc);
        String strUri = "STRId-" + secRef.hashCode();
        secRef.setID(strUri);
        String certUri = "CertId-" + certs[0].hashCode();
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Transforms transforms = null;
        SecurityTokenReference secRefSaml = null;
        try {
            if (senderVouches) {
                secRefSaml = new SecurityTokenReference(doc);
                String strSamlUri = "STRSAMLId-" + secRefSaml.hashCode();
                secRefSaml.setID(strSamlUri);
                Reference ref = new Reference(doc);
                ref.setURI("#" + assertion.getId());
                ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertion-1.1");
                secRefSaml.setReference(ref);
                Element ctx = this.createSTRParameter(doc);
                transforms = new Transforms(doc);
                transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                sig.addDocument("#" + strSamlUri, transforms);
            }
            for (int part = 0; part < this.parts.size(); ++part) {
                WSEncryptionPart encPart = (WSEncryptionPart)this.parts.get(part);
                String elemName = encPart.getName();
                String nmSpace = encPart.getNamespace();
                if (elemName.equals("Token")) {
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.keyIdentifierType == 1) {
                        sig.addDocument("#" + certUri, transforms);
                        continue;
                    }
                    sig.addDocument("#" + keyInfoUri, transforms);
                    continue;
                }
                if (elemName.equals("STRTransform")) {
                    Element ctx = this.createSTRParameter(doc);
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                    sig.addDocument("#" + strUri, transforms);
                    continue;
                }
                Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                if (body == null) {
                    throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                }
                transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                sig.addDocument("#" + this.setWsuId(body), transforms);
            }
        }
        catch (TransformationException e1) {
            throw new WSSecurityException(10, "noXMLSig", null, e1);
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(10, "noXMLSig", null, e1);
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        WSSecurityUtil.prependChildElement(doc, securityHeader, sig.getElement(), false);
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
        }
        switch (this.keyIdentifierType) {
            case 1: {
                Reference ref = new Reference(doc);
                if (senderVouches) {
                    ref.setURI("#" + certUri);
                    X509Security bstToken = null;
                    bstToken = new X509Security(doc);
                    bstToken.setX509Certificate(certs[0]);
                    bstToken.setID(certUri);
                    WSSecurityUtil.prependChildElement(doc, securityHeader, bstToken.getElement(), false);
                    wsDocInfo.setBst(bstToken.getElement());
                    ref.setValueType(bstToken.getValueType());
                } else {
                    ref.setURI("#" + assertion.getId());
                    ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertion-1.1");
                }
                secRef.setReference(ref);
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        info.addUnknownElement(secRef.getElement());
        Element samlToken = null;
        try {
            samlToken = (Element)assertion.toDOM(doc);
        }
        catch (SAMLException e2) {
            throw new WSSecurityException(10, "noSAMLdoc", null, e2);
        }
        if (senderVouches) {
            WSSecurityUtil.prependChildElement(doc, securityHeader, secRefSaml.getElement(), true);
        }
        wsDocInfo.setAssertion(samlToken);
        WSSecurityUtil.prependChildElement(doc, securityHeader, samlToken, true);
        WSDocInfoStore.store(wsDocInfo);
        try {
            if (senderVouches) {
                sig.sign(issuerCrypto.getPrivateKey(issuerKeyName, issuerKeyPW));
            } else {
                sig.sign(userCrypto.getPrivateKey(this.user, this.password));
            }
            this.signatureValue = sig.getSignatureValue();
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        catch (Exception e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        finally {
            WSDocInfoStore.delete(wsDocInfo);
        }
        if (tlog.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            tlog.debug((Object)("SignEnvelope: cre-Sig= " + (t1 - t0) + " set transform= " + (t2 - t1) + " sec-ref= " + (t3 - t2) + " signature= " + (t4 - t3)));
        }
        if (this.doDebug) {
            log.debug((Object)"Signing complete.");
        }
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

