/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.processor.DerivedKeyTokenProcessor;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.ProcessorBase;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceListProcessor
extends ProcessorBase {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$processor$ReferenceListProcessor == null ? (class$org$apache$ws$security$processor$ReferenceListProcessor = ReferenceListProcessor.class$("org.apache.ws.security.processor.ReferenceListProcessor")) : class$org$apache$ws$security$processor$ReferenceListProcessor).getName());
    private boolean debug = false;
    WSDocInfo wsDocInfo = null;
    static /* synthetic */ Class class$org$apache$ws$security$processor$ReferenceListProcessor;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wdi, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        this.debug = log.isDebugEnabled();
        if (this.debug) {
            log.debug((Object)"Found reference list element");
        }
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        this.wsDocInfo = wdi;
        ArrayList uris = this.handleReferenceList(elem, cb, crypto);
        returnResults.add(0, new WSSecurityEngineResult(4, uris));
    }

    private ArrayList handleReferenceList(Element elem, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        Document doc = elem.getOwnerDocument();
        Node tmpE = null;
        ArrayList<WSDataRef> dataRefUris = new ArrayList<WSDataRef>();
        for (tmpE = elem.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
            if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
            String dataRefURI = ((Element)tmpE).getAttribute("URI");
            WSDataRef dataRef = new WSDataRef(dataRefURI.substring(1));
            this.decryptDataRefEmbedded(doc, dataRefURI, dataRef, cb, crypto);
            dataRefUris.add(dataRef);
        }
        return dataRefUris;
    }

    public void decryptDataRefEmbedded(Document doc, String dataRefURI, WSDataRef dataRef, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found data reference: " + dataRefURI));
        }
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId(doc, dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        boolean content = X509Util.isContent(encBodyData);
        String symEncAlgo = X509Util.getEncAlgo(encBodyData);
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (tmpE == null) {
            throw new WSSecurityException(3, "noKeyinfo");
        }
        Element secRefToken = (Element)WSSecurityUtil.getDirectChild(tmpE, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SecretKey symmetricKey = null;
        symmetricKey = secRefToken == null ? X509Util.getSharedKey(tmpE, symEncAlgo, cb) : this.getKeyFromSecurityTokenReference(secRefToken, symEncAlgo, crypto, cb);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance(symEncAlgo);
            xmlCipher.init(2, symmetricKey);
        }
        catch (XMLEncryptionException e1) {
            throw new WSSecurityException(2, null, null, e1);
        }
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
        }
        try {
            String wsuPrefix;
            Node parentEncBody = encBodyData.getParentNode();
            List before_peers = ReferenceListProcessor.listChildren(parentEncBody);
            xmlCipher.doFinal(doc, encBodyData, content);
            if (parentEncBody.getLocalName().equals("EncryptedHeader") && parentEncBody.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
                Node decryptedHeader = parentEncBody.getFirstChild();
                Element decryptedHeaderClone = (Element)decryptedHeader.cloneNode(true);
                String sigId = decryptedHeaderClone.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                if (sigId == null || sigId.equals("")) {
                    String id = ((Element)parentEncBody).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    wsuPrefix = WSSecurityUtil.setNamespace(decryptedHeaderClone, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                    decryptedHeaderClone.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", wsuPrefix + ":Id", id);
                    dataRef.setWsuId(id.substring(1));
                } else {
                    dataRef.setWsuId(sigId);
                }
                Node encryptedHeader = decryptedHeader.getParentNode();
                parentEncBody.getParentNode().appendChild(decryptedHeaderClone);
                parentEncBody.getParentNode().removeChild(parentEncBody);
            }
            List after_peers = ReferenceListProcessor.listChildren(parentEncBody);
            List new_nodes = ReferenceListProcessor.newNodes(before_peers, after_peers);
            Iterator pos = new_nodes.iterator();
            while (pos.hasNext()) {
                Node node = (Node)pos.next();
                if (!(node instanceof Element)) continue;
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(node.getNamespaceURI()) && node.getAttributes().getNamedItemNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id") == null) {
                    wsuPrefix = WSSecurityUtil.setNamespace((Element)node, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                    ((Element)node).setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", wsuPrefix + ":Id", dataRefURI);
                    dataRef.setWsuId(dataRefURI.substring(1));
                }
                dataRef.setName(new QName(node.getNamespaceURI(), node.getLocalName()));
            }
        }
        catch (Exception e) {
            throw new WSSecurityException(6, null, null, e);
        }
    }

    public String getId() {
        return null;
    }

    private SecretKey getKeyFromSecurityTokenReference(Element secRefToken, String algorithm, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        SecurityTokenReference secRef = new SecurityTokenReference(secRefToken);
        byte[] decryptedData = null;
        if (secRef.containsReference()) {
            Reference reference = secRef.getReference();
            String uri = reference.getURI();
            String id = uri.substring(1);
            Processor p = this.wsDocInfo.getProcessor(id);
            if (p == null || !(p instanceof EncryptedKeyProcessor) && !(p instanceof DerivedKeyTokenProcessor) && !(p instanceof SAMLTokenProcessor)) {
                WSPasswordCallback pwcb = new WSPasswordCallback(id, 7);
                try {
                    cb.handle(new Callback[]{pwcb});
                }
                catch (Exception e) {
                    throw new WSSecurityException(0, "noPassword", new Object[]{id});
                }
                decryptedData = pwcb.getKey();
                if (decryptedData == null) {
                    throw new WSSecurityException(6, "unsupportedKeyId");
                }
            }
            if (p instanceof EncryptedKeyProcessor) {
                EncryptedKeyProcessor ekp = (EncryptedKeyProcessor)p;
                decryptedData = ekp.getDecryptedBytes();
            } else if (p instanceof DerivedKeyTokenProcessor) {
                DerivedKeyTokenProcessor dkp = (DerivedKeyTokenProcessor)p;
                decryptedData = dkp.getKeyBytes(WSSecurityUtil.getKeyLength(algorithm));
            } else if (p instanceof SAMLTokenProcessor) {
                SAMLTokenProcessor samlp = (SAMLTokenProcessor)p;
                SAMLKeyInfo keyInfo = SAMLUtil.getSAMLKeyInfo(samlp.getSamlTokenElement(), crypto, cb);
                decryptedData = keyInfo.getSecret();
            }
        } else if (secRef.containsKeyIdentifier()) {
            if (secRef.getKeyIdentifierValueType().equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1")) {
                String sha = secRef.getKeyIdentifierValue();
                WSPasswordCallback pwcb = new WSPasswordCallback(sha, 8);
                try {
                    cb.handle(new Callback[]{pwcb});
                }
                catch (Exception e) {
                    throw new WSSecurityException(0, "noPassword", new Object[]{sha});
                }
                decryptedData = pwcb.getKey();
            }
        } else {
            throw new WSSecurityException(6, "noReference");
        }
        return WSSecurityUtil.prepareSecretKey(algorithm, decryptedData);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

