/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.WSBaseMessage;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSSignEnvelope
extends WSBaseMessage {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$WSSignEnvelope == null ? (class$org$apache$ws$security$message$WSSignEnvelope = WSSignEnvelope.class$("org.apache.ws.security.message.WSSignEnvelope")) : class$org$apache$ws$security$message$WSSignEnvelope).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    protected boolean useSingleCert = true;
    protected String sigAlgo = null;
    protected String canonAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected WSSAddUsernameToken usernameToken = null;
    protected byte[] signatureValue = null;
    static /* synthetic */ Class class$org$apache$ws$security$message$WSSignEnvelope;

    public WSSignEnvelope() {
    }

    public WSSignEnvelope(String actor) {
        super(actor);
    }

    public WSSignEnvelope(String actor, boolean mu) {
        super(actor, mu);
    }

    public void setUseSingleCertificate(boolean useSingleCert) {
        this.useSingleCert = useSingleCert;
    }

    public boolean isUseSingleCertificate() {
        return this.useSingleCert;
    }

    public void setSignatureAlgorithm(String algo) {
        this.sigAlgo = algo;
    }

    public String getSignatureAlgorithm() {
        return this.sigAlgo;
    }

    public void setSigCanonicalization(String algo) {
        this.canonAlgo = algo;
    }

    public String getSigCanonicalization() {
        return this.canonAlgo;
    }

    public void setUsernameToken(WSSAddUsernameToken usernameToken) {
        this.usernameToken = usernameToken;
    }

    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    public Document build(Document doc, Crypto crypto) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (this.doDebug) {
            log.debug((Object)"Beginning signing...");
        }
        WSDocInfo wsDocInfo = new WSDocInfo(doc.hashCode());
        wsDocInfo.setCrypto(crypto);
        Element envelope = doc.getDocumentElement();
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(envelope);
        Element securityHeader = this.insertSecurityHeader(doc);
        String certUri = null;
        X509Certificate[] certs = null;
        if (this.keyIdentifierType != 7) {
            certs = crypto.getCertificates(this.user);
            if (certs == null || certs.length <= 0) {
                throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Signature"});
            }
            certUri = "CertId-" + certs[0].hashCode();
            if (this.sigAlgo == null) {
                String pubKeyAlgo = certs[0].getPublicKey().getAlgorithm();
                log.debug((Object)("automatic sig algo detection: " + pubKeyAlgo));
                if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                    this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                    this.sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                } else {
                    throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Signature - unkown public key Algo"});
                }
            }
        }
        XMLSignature sig = null;
        if (this.canonAlgo.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            Element canonElem = XMLUtils.createElementInSignatureSpace(doc, "CanonicalizationMethod");
            canonElem.setAttributeNS(null, "Algorithm", this.canonAlgo);
            if (this.wssConfig.isWsiBSPCompliant()) {
                Set prefixes = this.getInclusivePrefixes(securityHeader, false);
                InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(doc, prefixes);
                canonElem.appendChild(inclusiveNamespaces.getElement());
            }
            try {
                SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(doc, this.sigAlgo);
                sig = new XMLSignature(doc, null, signatureAlgorithm.getElement(), canonElem);
            }
            catch (XMLSecurityException e) {
                log.error((Object)"", (Throwable)e);
                throw new WSSecurityException(10, "noXMLSig");
            }
        }
        try {
            sig = new XMLSignature(doc, null, this.sigAlgo, this.canonAlgo);
        }
        catch (XMLSecurityException e) {
            log.error((Object)"", (Throwable)e);
            throw new WSSecurityException(10, "noXMLSig");
        }
        KeyInfo info = sig.getKeyInfo();
        String keyInfoUri = "KeyId-" + info.hashCode();
        info.setId(keyInfoUri);
        SecurityTokenReference secRef = new SecurityTokenReference(doc);
        String strUri = "STRId-" + secRef.hashCode();
        secRef.setID(strUri);
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        if (this.parts == null) {
            this.parts = new Vector();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            this.parts.add(encP);
        }
        Transforms transforms = null;
        for (int part = 0; part < this.parts.size(); ++part) {
            WSEncryptionPart encPart = (WSEncryptionPart)this.parts.get(part);
            String idToSign = encPart.getId();
            String elemName = encPart.getName();
            String nmSpace = encPart.getNamespace();
            try {
                if (idToSign != null) {
                    Element toSignById = WSSecurityUtil.findElementById(doc.getDocumentElement(), idToSign, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                    if (toSignById == null) {
                        toSignById = WSSecurityUtil.findElementById(doc.getDocumentElement(), idToSign, null);
                    }
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(toSignById)).getElement());
                    }
                    sig.addDocument("#" + idToSign, transforms);
                    continue;
                }
                if (elemName.equals("Token")) {
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.keyIdentifierType == 1) {
                        if (this.wssConfig.isWsiBSPCompliant()) {
                            transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(securityHeader)).getElement());
                        }
                        sig.addDocument("#" + certUri, transforms);
                        continue;
                    }
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(info.getElement())).getElement());
                    }
                    sig.addDocument("#" + keyInfoUri, transforms);
                    continue;
                }
                if (elemName.equals("STRTransform")) {
                    Element ctx = this.createSTRParameter(doc);
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", ctx);
                    sig.addDocument("#" + strUri, transforms);
                    continue;
                }
                if (elemName.equals("Assertion")) {
                    String id = null;
                    id = SAMLUtil.getAssertionId(envelope, elemName, nmSpace);
                    Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                    if (body == null) {
                        throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                    }
                    transforms = new Transforms(doc);
                    transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                    if (this.wssConfig.isWsiBSPCompliant()) {
                        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(body)).getElement());
                    }
                    String prefix = WSSecurityUtil.setNamespace(body, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                    body.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
                    sig.addDocument("#" + id, transforms);
                    continue;
                }
                Element body = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
                if (body == null) {
                    throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                }
                transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                if (this.wssConfig.isWsiBSPCompliant()) {
                    transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(body)).getElement());
                }
                sig.addDocument("#" + this.setWsuId(body), transforms);
                continue;
            }
            catch (TransformationException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, e1);
            }
            catch (XMLSignatureException e1) {
                throw new WSSecurityException(10, "noXMLSig", null, e1);
            }
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        WSSecurityUtil.prependChildElement(doc, securityHeader, sig.getElement(), false);
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
        }
        byte[] secretKey = null;
        switch (this.keyIdentifierType) {
            case 1: {
                Reference ref = new Reference(doc);
                ref.setURI("#" + certUri);
                BinarySecurity bstToken = null;
                if (!this.useSingleCert) {
                    bstToken = new PKIPathSecurity(doc);
                    ((PKIPathSecurity)bstToken).setX509Certificates(certs, false, crypto);
                } else {
                    bstToken = new X509Security(doc);
                    ((X509Security)bstToken).setX509Certificate(certs[0]);
                }
                ref.setValueType(bstToken.getValueType());
                secRef.setReference(ref);
                bstToken.setID(certUri);
                WSSecurityUtil.prependChildElement(doc, securityHeader, bstToken.getElement(), false);
                wsDocInfo.setBst(bstToken.getElement());
                break;
            }
            case 2: {
                XMLX509IssuerSerial data = new XMLX509IssuerSerial(doc, certs[0]);
                X509Data x509Data = new X509Data(doc);
                x509Data.add(data);
                secRef.setX509IssuerSerial(x509Data);
                break;
            }
            case 3: {
                secRef.setKeyIdentifier(certs[0]);
                break;
            }
            case 4: {
                secRef.setKeyIdentifierSKI(certs[0], crypto);
                break;
            }
            case 7: {
                Reference refUt = new Reference(doc);
                refUt.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
                String utId = this.usernameToken.getId();
                if (utId == null) {
                    utId = "usernameTokenId-" + this.usernameToken.hashCode();
                    this.usernameToken.setId(utId);
                }
                refUt.setURI("#" + utId);
                secRef.setReference(refUt);
                secretKey = this.usernameToken.getSecretKey();
                break;
            }
            case 8: {
                secRef.setKeyIdentifierThumb(certs[0]);
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        info.addUnknownElement(secRef.getElement());
        WSDocInfoStore.store(wsDocInfo);
        try {
            if (this.keyIdentifierType == 7) {
                sig.sign(sig.createSecretKey(secretKey));
            } else {
                sig.sign(crypto.getPrivateKey(this.user, this.password));
            }
            this.signatureValue = sig.getSignatureValue();
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        catch (Exception e1) {
            throw new WSSecurityException(10, null, null, e1);
        }
        finally {
            WSDocInfoStore.delete(wsDocInfo);
        }
        if (tlog.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            tlog.debug((Object)("SignEnvelope: cre-Sig= " + (t1 - t0) + " set transform= " + (t2 - t1) + " sec-ref= " + (t3 - t2) + " signature= " + (t4 - t3)));
        }
        if (this.doDebug) {
            log.debug((Object)"Signing complete.");
        }
        return doc;
    }

    protected Element createSTRParameter(Document doc) {
        Element transformParam = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
        WSSecurityUtil.setNamespace(transformParam, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        Element canonElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        WSSecurityUtil.setNamespace(canonElem, "http://www.w3.org/2000/09/xmldsig#", "ds");
        canonElem.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        transformParam.appendChild(canonElem);
        return transformParam;
    }

    protected Set getInclusivePrefixes(Element target) {
        return this.getInclusivePrefixes(target, true);
    }

    protected Set getInclusivePrefixes(Element target, boolean excludeVisible) {
        Node attribute;
        int i;
        NamedNodeMap attributes;
        HashSet<String> result = new HashSet<String>();
        Node parent = target;
        while (!(parent.getParentNode() instanceof Document)) {
            parent = parent.getParentNode();
            attributes = parent.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (attribute.getNamespaceURI() == null || !attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                if (attribute.getNodeName().equals("xmlns")) {
                    result.add("#default");
                    continue;
                }
                result.add(attribute.getLocalName());
            }
        }
        if (excludeVisible) {
            attributes = target.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (attribute.getNamespaceURI() != null && attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                    if (attribute.getNodeName().equals("xmlns")) {
                        result.remove("#default");
                    } else {
                        result.remove(attribute.getLocalName());
                    }
                }
                if (attribute.getPrefix() == null) continue;
                result.remove(attribute.getPrefix());
            }
            if (target.getPrefix() == null) {
                result.remove("#default");
            } else {
                result.remove(target.getPrefix());
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

