/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.X509Token;

public class X509TokenBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        X509Token x509Token = new X509Token(2);
        OMElement policyElement = element.getFirstElement();
        OMAttribute includeAttr = element.getAttribute(SP12Constants.INCLUDE_TOKEN);
        if (includeAttr != null) {
            int inclusion = SP12Constants.getInclusionFromAttributeValue(includeAttr.getAttributeValue());
            x509Token.setInclusion(inclusion);
        }
        if (policyElement != null) {
            if (policyElement.getFirstChildWithName(SP12Constants.REQUIRE_DERIVED_KEYS) != null) {
                x509Token.setDerivedKeys(true);
            } else if (policyElement.getFirstChildWithName(SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS) != null) {
                x509Token.setImpliedDerivedKeys(true);
            } else if (policyElement.getFirstChildWithName(SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS) != null) {
                x509Token.setExplicitDerivedKeys(true);
            }
            Policy policy = PolicyEngine.getPolicy(element.getFirstElement());
            policy = (Policy)policy.normalize(false);
            Iterator iterator = policy.getAlternatives();
            if (iterator.hasNext()) {
                this.processAlternative((List)iterator.next(), x509Token);
            }
        }
        return x509Token;
    }

    private void processAlternative(List assertions, X509Token parent) {
        Iterator iterator = assertions.iterator();
        while (iterator.hasNext()) {
            Assertion assertion = (Assertion)iterator.next();
            QName name = assertion.getName();
            if (SP12Constants.REQUIRE_KEY_IDENTIFIRE_REFERENCE.equals(name)) {
                parent.setRequireKeyIdentifierReference(true);
                continue;
            }
            if (SP12Constants.REQUIRE_ISSUER_SERIAL_REFERENCE.equals(name)) {
                parent.setRequireIssuerSerialReference(true);
                continue;
            }
            if (SP12Constants.REQUIRE_EMBEDDED_TOKEN_REFERENCE.equals(name)) {
                parent.setRequireEmbeddedTokenReference(true);
                continue;
            }
            if (SP12Constants.REQUIRE_THUMBPRINT_REFERENCE.equals(name)) {
                parent.setRequireThumbprintReference(true);
                continue;
            }
            if (SP12Constants.WSS_X509_V1_TOKEN_10.equals(name)) {
                parent.setTokenVersionAndType("WssX509V1Token10");
                continue;
            }
            if (SP12Constants.WSS_X509_V1_TOKEN_11.equals(name)) {
                parent.setTokenVersionAndType("WssX509V1Token11");
                continue;
            }
            if (SP12Constants.WSS_X509_V3_TOKEN_10.equals(name)) {
                parent.setTokenVersionAndType("WssX509V3Token10");
                continue;
            }
            if (SP12Constants.WSS_X509_V3_TOKEN_11.equals(name)) {
                parent.setTokenVersionAndType("WssX509V3Token11");
                continue;
            }
            if (SP12Constants.WSS_X509_PKCS7_TOKEN_10.equals(name)) {
                parent.setTokenVersionAndType("WssX509Pkcs7Token10");
                continue;
            }
            if (SP12Constants.WSS_X509_PKCS7_TOKEN_11.equals(name)) {
                parent.setTokenVersionAndType("WssX509Pkcs7Token11");
                continue;
            }
            if (SP12Constants.WSS_X509_PKI_PATH_V1_TOKEN_10.equals(name)) {
                parent.setTokenVersionAndType("WssX509PkiPathV1Token10");
                continue;
            }
            if (!SP12Constants.WSS_X509_PKI_PATH_V1_TOKEN_11.equals(name)) continue;
            parent.setTokenVersionAndType("WssX509PkiPathV1Token11");
        }
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.X509_TOKEN};
    }
}

