/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.axiom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.axiom.AxiomDataBinding;
import org.apache.tuscany.sca.databinding.axiom.AxiomHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMElementWrapperHandler
implements WrapperHandler<OMElement> {
    private OMFactory factory = OMAbstractFactory.getOMFactory();
    private static final QName XSI_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi");

    public OMElement create(Operation operation, boolean input) {
        WrapperInfo wrapperInfo = operation.getWrapper();
        ElementInfo element = input ? wrapperInfo.getInputWrapperElement() : wrapperInfo.getOutputWrapperElement();
        OMElement wrapper = AxiomHelper.createOMElement(this.factory, element.getQName());
        return wrapper;
    }

    public void setChildren(OMElement wrapper, Object[] childObjects, Operation operation, boolean input) {
        List childElements = input ? operation.getWrapper().getInputChildElements() : operation.getWrapper().getOutputChildElements();
        for (int i = 0; i < childElements.size(); ++i) {
            this.setChild(wrapper, i, (ElementInfo)childElements.get(i), childObjects[i]);
        }
    }

    public void setChild(OMElement wrapper, int i, ElementInfo childElement, Object value) {
        if (childElement.isMany()) {
            Object[] elements = (Object[])value;
            if (value != null) {
                for (Object e : elements) {
                    this.addChild(wrapper, childElement, (OMElement)e);
                }
            }
        } else {
            OMElement element = (OMElement)value;
            this.addChild(wrapper, childElement, element);
        }
    }

    private void addChild(OMElement wrapper, ElementInfo childElement, OMElement element) {
        if (element == null) {
            OMElement e = wrapper.getOMFactory().createOMElement(childElement.getQName(), wrapper);
            this.attachXSINil(e);
            return;
        }
        QName elementName = childElement.getQName();
        if (!elementName.equals(element.getQName())) {
            OMNamespace namespace = this.factory.createOMNamespace(elementName.getNamespaceURI(), elementName.getPrefix());
            element.setNamespace(namespace);
            element.setLocalName(childElement.getQName().getLocalPart());
        }
        wrapper.addChild(element);
    }

    public List getChildren(OMElement wrapper, Operation operation, boolean input) {
        List childElements = input ? operation.getWrapper().getInputChildElements() : operation.getWrapper().getOutputChildElements();
        ArrayList<Object> elements = new ArrayList<Object>();
        int i = 0;
        for (ElementInfo e : childElements) {
            elements.add(this.getChild(wrapper, e, i));
            ++i;
        }
        return elements;
    }

    public DataType getWrapperType(Operation operation, boolean input) {
        WrapperInfo wrapper = operation.getWrapper();
        ElementInfo element = input ? wrapper.getInputWrapperElement() : wrapper.getOutputWrapperElement();
        DataTypeImpl wrapperType = new DataTypeImpl(AxiomDataBinding.NAME, OMElement.class, (Object)new XMLType(element));
        return wrapperType;
    }

    public boolean isInstance(Object wrapperObj, Operation operation, boolean input) {
        WrapperInfo wrapperInfo = operation.getWrapper();
        ElementInfo element = input ? wrapperInfo.getInputWrapperElement() : wrapperInfo.getOutputWrapperElement();
        OMElement wrapper = (OMElement)wrapperObj;
        return element.getQName().equals(wrapper.getQName());
    }

    private List<List<OMElement>> getElements(OMElement wrapper) {
        ArrayList<List<OMElement>> elements = new ArrayList<List<OMElement>>();
        ArrayList<OMElement> current = new ArrayList<OMElement>();
        elements.add(current);
        boolean first = true;
        QName last = null;
        Iterator i = wrapper.getChildElements();
        while (i.hasNext()) {
            OMElement element = (OMElement)i.next();
            if (first || element.getQName().equals(last)) {
                current.add(element);
                last = element.getQName();
            } else {
                current = new ArrayList();
                elements.add(current);
                current.add(element);
                last = element.getQName();
            }
            first = false;
        }
        return elements;
    }

    public Object getChild(OMElement wrapper, ElementInfo childElement, int index) {
        Iterator children = wrapper.getChildrenWithName(childElement.getQName());
        if (!children.hasNext()) {
            Object[] array;
            List<List<OMElement>> list = this.getElements(wrapper);
            List<OMElement> elements = list.get(index);
            if (!childElement.isMany()) {
                return elements.isEmpty() ? null : this.attachXSIType(childElement, elements.get(0));
            }
            for (Object item : array = elements.toArray()) {
                this.attachXSIType(childElement, (OMElement)item);
            }
            return array;
        }
        if (!childElement.isMany()) {
            if (children.hasNext()) {
                OMElement child = (OMElement)children.next();
                this.attachXSIType(childElement, child);
                return child;
            }
            return null;
        }
        ArrayList<OMElement> elements = new ArrayList<OMElement>();
        while (children.hasNext()) {
            OMElement child = (OMElement)children.next();
            this.attachXSIType(childElement, child);
            elements.add(child);
        }
        return elements.toArray();
    }

    private OMElement attachXSIType(ElementInfo childElement, OMElement element) {
        OMAttribute attr;
        TypeInfo type = childElement.getType();
        if (type != null && type.getQName() != null && (attr = element.getAttribute(XSI_TYPE_QNAME)) == null) {
            String typeNS = type.getQName().getNamespaceURI();
            if ("http://www.w3.org/2001/XMLSchema".equals(typeNS)) {
                return element;
            }
            OMNamespace ns = element.getOMFactory().createOMNamespace(typeNS, "_typens_");
            element.declareNamespace(ns);
            OMNamespace xsiNS = element.getOMFactory().createOMNamespace(XSI_TYPE_QNAME.getNamespaceURI(), XSI_TYPE_QNAME.getPrefix());
            element.declareNamespace(xsiNS);
            attr = element.getOMFactory().createOMAttribute("type", xsiNS, "_typens_:" + type.getQName().getLocalPart());
            element.addAttribute(attr);
        }
        return element;
    }

    private void attachXSINil(OMElement element) {
        OMNamespace xsiNS = element.getOMFactory().createOMNamespace(XSI_TYPE_QNAME.getNamespaceURI(), XSI_TYPE_QNAME.getPrefix());
        element.declareNamespace(xsiNS);
        OMAttribute attr = element.getOMFactory().createOMAttribute("nil", xsiNS, "true");
        element.addAttribute(attr);
    }
}

