/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.transport;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

public class TransportReferenceInterceptor
implements Interceptor {
    private Invoker next;

    public Message invoke(Message msg) {
        try {
            Object resp = null;
            resp = msg.getOperation().isNonBlocking() ? this.invokeTargetOneWay(msg) : this.invokeTarget(msg);
            msg.setBody(resp);
        }
        catch (AxisFault e) {
            if (e.getDetail() != null) {
                FaultException f = new FaultException(e.getMessage(), (Object)e.getDetail(), (Throwable)e);
                f.setFaultName(e.getDetail().getQName());
                msg.setFaultBody((Object)f);
            } else {
                msg.setFaultBody((Object)e);
            }
        }
        catch (Throwable e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    protected Object invokeTarget(Message msg) throws AxisFault {
        final OperationClient operationClient = (OperationClient)msg.getBindingContext();
        MessageContext requestMC = operationClient.getMessageContext("Out");
        requestMC.getOptions().setProperty("REUSE_HTTP_CLIENT", Boolean.TRUE);
        requestMC.getOptions().setTimeOutInMilliSeconds(240000L);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AxisFault {
                    operationClient.execute(true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            operationClient.complete(requestMC);
            throw (AxisFault)e.getException();
        }
        MessageContext responseMC = operationClient.getMessageContext("In");
        OMElement response = responseMC.getEnvelope().getBody().getFirstElement();
        if (response != null) {
            response.build();
        }
        operationClient.complete(requestMC);
        return response;
    }

    protected Object invokeTargetOneWay(Message msg) throws AxisFault {
        OperationClient operationClient = (OperationClient)msg.getBindingContext();
        MessageContext requestMC = operationClient.getMessageContext("Out");
        Options opt = requestMC.getOptions();
        opt.setProperty("REUSE_HTTP_CLIENT", Boolean.TRUE);
        opt.setUseSeparateListener(true);
        opt.setProperty("AutoReleaseConnection", Boolean.TRUE);
        operationClient.execute(false);
        return null;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

