/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.rampart.RampartException;
import org.apache.ws.security.WSSecurityException;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class MessageOptimizer {
    private static final String CIPHER_ELEMENT = "//xenc:EncryptedData/xenc:CipherData/xenc:CipherValue";

    public static void optimize(SOAPEnvelope env, Vector expressions, Map namespaces) throws RampartException {
        SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
        nsCtx.addNamespace("xenc", "http://www.w3.org/2001/04/xmlenc#");
        nsCtx.addNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        nsCtx.addNamespace("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        nsCtx.addNamespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Iterator keys = namespaces.keySet().iterator();
        while (keys.hasNext()) {
            String strPrefix = (String)keys.next();
            String strNS = (String)namespaces.get(strPrefix);
            nsCtx.addNamespace(strPrefix, strNS);
        }
        try {
            for (int i = 0; i < expressions.size(); ++i) {
                String exp = (String)expressions.get(i);
                AXIOMXPath xp = new AXIOMXPath(exp);
                xp.setNamespaceContext((NamespaceContext)nsCtx);
                List list = xp.selectNodes(env);
                Iterator elements = list.iterator();
                while (elements.hasNext()) {
                    OMElement element = (OMElement)elements.next();
                    OMText text = (OMText)element.getFirstOMChild();
                    text.setOptimize(true);
                }
            }
        }
        catch (JaxenException e) {
            throw new RampartException("Error in XPath ", e);
        }
    }

    public static void optimize(SOAPEnvelope env, String optimizeParts) throws WSSecurityException {
        String separater = "<>";
        StringTokenizer tokenizer = new StringTokenizer(optimizeParts, separater);
        while (tokenizer.hasMoreTokens()) {
            String xpathExpr = tokenizer.nextToken();
            List list = MessageOptimizer.findElements(env, xpathExpr);
            Iterator cipherValueElements = list.iterator();
            while (cipherValueElements.hasNext()) {
                OMElement element = (OMElement)cipherValueElements.next();
                OMText text = (OMText)element.getFirstOMChild();
                text.setOptimize(true);
            }
        }
    }

    private static List findElements(OMElement elem, String expression) throws WSSecurityException {
        try {
            AXIOMXPath xp = new AXIOMXPath(expression);
            SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
            nsCtx.addNamespace("xenc", "http://www.w3.org/2001/04/xmlenc#");
            nsCtx.addNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
            nsCtx.addNamespace("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            nsCtx.addNamespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            xp.setNamespaceContext((NamespaceContext)nsCtx);
            return xp.selectNodes(elem);
        }
        catch (JaxenException e) {
            throw new WSSecurityException(e.getMessage(), e);
        }
    }
}

