/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.event.TransportErrorListener;
import org.apache.axis2.transport.base.event.TransportErrorSource;
import org.apache.axis2.transport.base.event.TransportErrorSourceSupport;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSConnectionFactoryManager;
import org.apache.axis2.transport.jms.JMSEndpoint;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.axis2.transport.jms.ServiceTaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSListener
extends AbstractTransportListenerEx<JMSEndpoint>
implements ManagementSupport,
TransportErrorSource {
    public static final String TRANSPORT_NAME = "jms";
    private JMSConnectionFactoryManager connFacManager;
    private final TransportErrorSourceSupport tess = new TransportErrorSourceSupport(this);

    @Override
    public void init(ConfigurationContext cfgCtx, TransportInDescription trpInDesc) throws AxisFault {
        super.init(cfgCtx, trpInDesc);
        this.connFacManager = new JMSConnectionFactoryManager(trpInDesc);
        this.log.info((Object)"JMS Transport Receiver/Listener initialized...");
    }

    @Override
    protected JMSEndpoint createEndpoint() {
        return new JMSEndpoint(this, this.workerPool);
    }

    @Override
    protected void startEndpoint(JMSEndpoint endpoint) throws AxisFault {
        ServiceTaskManager stm = endpoint.getServiceTaskManager();
        stm.start();
        for (int i = 0; i < 3; ++i) {
            if (stm.getActiveTaskCount() > 0) {
                this.log.info((Object)("Started to listen on destination : " + stm.getDestinationJNDIName() + " of type " + JMSUtils.getDestinationTypeAsString(stm.getDestinationType()) + " for service " + stm.getServiceName()));
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        this.log.warn((Object)("Polling tasks on destination : " + stm.getDestinationJNDIName() + " of type " + JMSUtils.getDestinationTypeAsString(stm.getDestinationType()) + " for service " + stm.getServiceName() + " have not yet started after 3 seconds .."));
    }

    @Override
    protected void stopEndpoint(JMSEndpoint endpoint) {
        ServiceTaskManager stm = endpoint.getServiceTaskManager();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopping listening on destination : " + stm.getDestinationJNDIName() + " for service : " + stm.getServiceName()));
        }
        stm.stop();
        this.log.info((Object)("Stopped listening for JMS messages to service : " + endpoint.getServiceName()));
    }

    public JMSConnectionFactory getConnectionFactory(AxisService service) {
        Parameter conFacParam = service.getParameter("transport.jms.ConnectionFactory");
        if (conFacParam != null) {
            return this.connFacManager.getJMSConnectionFactory((String)conFacParam.getValue());
        }
        return this.connFacManager.getJMSConnectionFactory("default");
    }

    @Override
    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            for (JMSEndpoint endpoint : this.getEndpoints()) {
                endpoint.getServiceTaskManager().pause();
            }
            this.state = 2;
            this.log.info((Object)"Listener paused");
        }
        catch (AxisJMSException e) {
            this.log.error((Object)"At least one service could not be paused", (Throwable)e);
        }
    }

    @Override
    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        try {
            for (JMSEndpoint endpoint : this.getEndpoints()) {
                endpoint.getServiceTaskManager().resume();
            }
            this.state = 1;
            this.log.info((Object)"Listener resumed");
        }
        catch (AxisJMSException e) {
            this.log.error((Object)"At least one service could not be resumed", (Throwable)e);
        }
    }

    @Override
    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.stop();
            this.state = 0;
            this.log.info((Object)("Listener shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (Exception e) {
            this.handleException("Error shutting down the listener for maintenence", e);
        }
    }

    @Override
    public void addErrorListener(TransportErrorListener listener) {
        this.tess.addErrorListener(listener);
    }

    @Override
    public void removeErrorListener(TransportErrorListener listener) {
        this.tess.removeErrorListener(listener);
    }

    void error(AxisService service, Throwable ex) {
        this.tess.error(service, ex);
    }
}

