/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpService;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.axis2.transport.http.server.IOProcessorCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.protocol.BasicHttpContext;

public class HttpServiceProcessor
implements IOProcessor {
    private static final Log LOG = LogFactory.getLog(HttpServiceProcessor.class);
    private static AtomicLong counter = new AtomicLong(0L);
    private AtomicBoolean terminated;
    private final AxisHttpService httpservice;
    private final AxisHttpConnection conn;
    private final IOProcessorCallback callback;
    private final long id;

    public HttpServiceProcessor(AxisHttpService httpservice, AxisHttpConnection conn, IOProcessorCallback callback) {
        this.httpservice = httpservice;
        this.conn = conn;
        this.callback = callback;
        this.terminated = new AtomicBoolean(false);
        this.id = counter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.debug((Object)"New connection thread");
        BasicHttpContext context = new BasicHttpContext(null);
        try {
            while (!Thread.interrupted() && !this.isDestroyed() && this.conn.isOpen()) {
                this.httpservice.handleRequest(this.conn, context);
            }
        }
        catch (ConnectionClosedException ex) {
            LOG.debug((Object)"Client closed connection");
        }
        catch (IOException ex) {
            if (ex instanceof SocketTimeoutException) {
                LOG.debug((Object)ex.getMessage());
            } else if (ex instanceof SocketException) {
                LOG.debug((Object)ex.getMessage());
            } else {
                LOG.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        catch (HttpException ex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("HTTP protocol error: " + ex.getMessage()));
            }
        }
        finally {
            this.destroy();
            if (this.callback == null) {
                throw new NullPointerException("The callback object can't be null");
            }
            this.callback.completed(this);
        }
    }

    public void close() throws IOException {
        this.conn.close();
    }

    public void destroy() {
        if (this.terminated.compareAndSet(false, true)) {
            try {
                this.close();
            }
            catch (IOException ex) {
                LOG.debug((Object)"I/O error shutting down connection");
            }
        }
    }

    public boolean isDestroyed() {
        return this.terminated.get();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpServiceProcessor other = (HttpServiceProcessor)obj;
        return this.id == other.id;
    }
}

