/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpService;
import org.apache.axis2.transport.http.server.HttpConnectionManager;
import org.apache.axis2.transport.http.server.HttpFactory;
import org.apache.axis2.transport.http.server.HttpServiceProcessor;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.axis2.transport.http.server.IOProcessorCallback;
import org.apache.axis2.transport.http.server.RequestSessionCookie;
import org.apache.axis2.transport.http.server.ResponseSessionCookie;
import org.apache.axis2.transport.http.server.WorkerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class DefaultHttpConnectionManager
implements HttpConnectionManager {
    private static Log LOG = LogFactory.getLog(DefaultHttpConnectionManager.class);
    private final ConfigurationContext configurationContext;
    private final Executor executor;
    private final WorkerFactory workerfactory;
    private final HttpParams params;
    private final List processors;
    private HttpFactory httpFactory = null;

    public DefaultHttpConnectionManager(ConfigurationContext configurationContext, Executor executor, WorkerFactory workerfactory, HttpParams params) {
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context may not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor may not be null");
        }
        if (workerfactory == null) {
            throw new IllegalArgumentException("Worker factory may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.configurationContext = configurationContext;
        this.executor = executor;
        this.workerfactory = workerfactory;
        this.params = params;
        this.processors = new LinkedList();
    }

    public DefaultHttpConnectionManager(ConfigurationContext configurationContext, Executor executor, WorkerFactory workerfactory, HttpParams params, HttpFactory httpFactory) {
        this(configurationContext, executor, workerfactory, params);
        this.httpFactory = httpFactory;
    }

    private synchronized void cleanup() {
        Iterator i = this.processors.iterator();
        while (i.hasNext()) {
            IOProcessor processor = (IOProcessor)i.next();
            if (!processor.isDestroyed()) continue;
            i.remove();
        }
    }

    private synchronized void addProcessor(IOProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("The processor can't be null");
        }
        this.processors.add(processor);
    }

    synchronized void removeProcessor(IOProcessor processor) throws NullPointerException {
        if (processor == null) {
            throw new NullPointerException("The processor can't be null");
        }
        this.processors.remove(processor);
    }

    public void process(AxisHttpConnection conn) {
        HttpResponseFactory responseFactory;
        ConnectionReuseStrategy connStrategy;
        HttpProcessor httpProcessor;
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        this.cleanup();
        if (this.httpFactory != null) {
            httpProcessor = this.httpFactory.newHttpProcessor();
            connStrategy = this.httpFactory.newConnStrategy();
            responseFactory = this.httpFactory.newResponseFactory();
        } else {
            BasicHttpProcessor p = new BasicHttpProcessor();
            p.addInterceptor(new RequestSessionCookie());
            p.addInterceptor(new ResponseDate());
            p.addInterceptor(new ResponseServer());
            p.addInterceptor(new ResponseContent());
            p.addInterceptor(new ResponseConnControl());
            p.addInterceptor(new ResponseSessionCookie());
            httpProcessor = p;
            connStrategy = new DefaultConnectionReuseStrategy();
            responseFactory = new DefaultHttpResponseFactory();
        }
        AxisHttpService httpService = new AxisHttpService(httpProcessor, connStrategy, responseFactory, this.configurationContext, this.workerfactory.newWorker());
        httpService.setParams(this.params);
        IOProcessorCallback callback = new IOProcessorCallback(){

            public void completed(IOProcessor processor) {
                DefaultHttpConnectionManager.this.removeProcessor(processor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(processor + " terminated"));
                }
            }
        };
        HttpServiceProcessor processor = new HttpServiceProcessor(httpService, conn, callback);
        this.addProcessor(processor);
        this.executor.execute(processor);
    }

    public synchronized void shutdown() {
        for (int i = 0; i < this.processors.size(); ++i) {
            IOProcessor processor = (IOProcessor)this.processors.get(i);
            processor.destroy();
        }
        this.processors.clear();
    }
}

