/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.server.HttpFactory;
import org.apache.axis2.transport.http.server.SessionManager;
import org.apache.axis2.transport.http.server.SimpleHttpServer;
import org.apache.axis2.util.OptionsParser;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleHTTPServer
implements TransportListener {
    private static final Log log = LogFactory.getLog(SimpleHTTPServer.class);
    SimpleHttpServer embedded = null;
    private String localAddress;
    int port = -1;
    public static int DEFAULT_PORT = 8080;
    private String hostAddress = null;
    protected ConfigurationContext configurationContext;
    protected HttpFactory httpFactory;
    private SessionManager sessionManager;

    public SimpleHTTPServer() {
    }

    public SimpleHTTPServer(ConfigurationContext configurationContext, int port) throws AxisFault {
        this(new HttpFactory(configurationContext, port));
    }

    public SimpleHTTPServer(HttpFactory httpFactory) throws AxisFault {
        this.httpFactory = httpFactory;
        this.configurationContext = httpFactory.getConfigurationContext();
        this.port = httpFactory.getPort();
        TransportInDescription httpDescription = new TransportInDescription("http");
        httpDescription.setReceiver(this);
        httpFactory.getListenerManager().addListener(httpDescription, true);
        this.sessionManager = new SessionManager();
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
        try {
            this.configurationContext = axisConf;
            Parameter param = transprtIn.getParameter("port");
            if (param != null) {
                this.port = Integer.parseInt((String)param.getValue());
            }
            if (this.httpFactory == null) {
                this.httpFactory = new HttpFactory(this.configurationContext, this.port);
            }
            this.hostAddress = (param = transprtIn.getParameter("hostname")) != null ? ((String)param.getValue()).trim() : this.httpFactory.getHostAddress();
        }
        catch (Exception e1) {
            throw AxisFault.makeFault(e1);
        }
    }

    public static void main(String[] args) throws Exception {
        String paramPort;
        int port = DEFAULT_PORT;
        OptionsParser optionsParser = new OptionsParser(args);
        args = optionsParser.getRemainingArgs();
        if (optionsParser.isFlagSet('?') > 0 || optionsParser.isFlagSet('h') > 0 || args == null || args.length == 0 || args.length > 3) {
            SimpleHTTPServer.printUsage();
        }
        if ((paramPort = optionsParser.isValueSet('p')) != null) {
            port = Integer.parseInt(paramPort);
        }
        boolean startAllTransports = "all".equals(optionsParser.isValueSet('t'));
        String repository = optionsParser.isValueSet('r');
        if (repository == null) {
            args = optionsParser.getRemainingArgs();
            if (args != null && args[0] != null && !args[0].equals("")) {
                repository = args[0];
            } else {
                SimpleHTTPServer.printUsage();
            }
        }
        System.out.println("[SimpleHTTPServer] Starting");
        System.out.println("[SimpleHTTPServer] Using the Axis2 Repository " + new File(repository).getAbsolutePath());
        System.out.println("[SimpleHTTPServer] Listening on port " + port);
        try {
            ConfigurationContext configctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem(repository, null);
            SimpleHTTPServer receiver = new SimpleHTTPServer(configctx, port);
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(receiver));
            receiver.start();
            TransportInDescription trsIn = new TransportInDescription("http");
            trsIn.setReceiver(receiver);
            ListenerManager listenerManager = configctx.getListenerManager();
            listenerManager.addListener(trsIn, true);
            if (startAllTransports) {
                for (QName qName : configctx.getAxisConfiguration().getTransportsIn().keySet()) {
                    if (new QName("http").equals(qName)) continue;
                    trsIn = configctx.getAxisConfiguration().getTransportsIn().get(qName);
                    listenerManager.addListener(trsIn, false);
                }
            }
            System.out.println("[SimpleHTTPServer] Started");
        }
        catch (Throwable t) {
            log.fatal((Object)"Error starting SimpleHTTPServer", t);
            System.out.println("[SimpleHTTPServer] Shutting down");
        }
    }

    public static void printUsage() {
        System.out.println("Usage: SimpleHTTPServer [options] -r <repository>");
        System.out.println(" Opts: -? this message");
        System.out.println();
        System.out.println("       -p port :to listen on (default is 8080)");
        System.out.println("       -t all  :to start all transports defined in the axis2 configuration");
        System.exit(1);
    }

    public void start() throws AxisFault {
        try {
            this.embedded = new SimpleHttpServer(this.httpFactory, this.port);
            this.embedded.init();
            this.embedded.start();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
    }

    public void stop() {
        System.out.println("[SimpleHTTPServer] Stop called");
        if (this.embedded != null) {
            try {
                this.embedded.destroy();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String ipAddress;
        if (this.hostAddress != null) {
            if (this.embedded != null) {
                String endpointRefernce = this.hostAddress;
                endpointRefernce = this.configurationContext.getServiceContextPath().startsWith("/") ? endpointRefernce + this.configurationContext.getServiceContextPath() + "/" + serviceName : endpointRefernce + '/' + this.configurationContext.getServiceContextPath() + "/" + serviceName;
                return new EndpointReference[]{new EndpointReference(endpointRefernce + "/")};
            }
            throw new AxisFault("Unable to generate EPR for the transport : http");
        }
        if (ip != null) {
            ipAddress = ip;
        } else {
            try {
                if (this.localAddress == null) {
                    this.localAddress = Utils.getIpAddress(this.configurationContext.getAxisConfiguration());
                }
                ipAddress = this.localAddress == null ? "127.0.0.1" : this.localAddress;
            }
            catch (SocketException e) {
                throw AxisFault.makeFault(e);
            }
        }
        if (this.embedded != null) {
            String endpointRefernce = "http://" + ipAddress + ":" + this.embedded.getPort();
            endpointRefernce = this.configurationContext.getServiceContextPath().startsWith("/") ? endpointRefernce + this.configurationContext.getServiceContextPath() + "/" + serviceName : endpointRefernce + '/' + this.configurationContext.getServiceContextPath() + "/" + serviceName;
            return new EndpointReference[]{new EndpointReference(endpointRefernce + "/")};
        }
        throw new AxisFault("Unable to generate EPR for the transport : http");
    }

    public HttpFactory getHttpFactory() {
        return this.httpFactory;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public boolean isRunning() {
        if (this.embedded == null) {
            return false;
        }
        return this.embedded.isRunning();
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        String sessionKey = (String)messageContext.getProperty("Cookie");
        return this.sessionManager.getSessionContext(sessionKey);
    }

    public void destroy() {
        this.configurationContext = null;
    }

    static class ShutdownThread
    extends Thread {
        private SimpleHTTPServer server = null;

        public ShutdownThread(SimpleHTTPServer server) {
            this.server = server;
        }

        public void run() {
            System.out.println("[SimpleHTTPServer] Shutting down");
            this.server.stop();
            System.out.println("[SimpleHTTPServer] Shutdown complete");
        }
    }
}

