/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.datagram;

import java.io.ByteArrayInputStream;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.base.datagram.DatagramEndpoint;
import org.apache.axis2.transport.base.datagram.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessPacketTask
implements Runnable {
    private static final Log log = LogFactory.getLog(ProcessPacketTask.class);
    private final DatagramEndpoint endpoint;
    private final byte[] data;
    private final int length;

    public ProcessPacketTask(DatagramEndpoint endpoint, byte[] data, int length) {
        this.endpoint = endpoint;
        this.data = data;
        this.length = length;
    }

    public void run() {
        MetricsCollector metrics = this.endpoint.getMetrics();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.data, 0, this.length);
            MessageContext msgContext = this.endpoint.createMessageContext();
            SOAPEnvelope envelope = TransportUtils.createSOAPMessage(msgContext, inputStream, this.endpoint.getContentType());
            msgContext.setEnvelope(envelope);
            AxisEngine.receive(msgContext);
            metrics.incrementMessagesReceived();
            metrics.incrementBytesReceived(this.length);
        }
        catch (Exception ex) {
            metrics.incrementFaultsReceiving();
            StringBuilder buffer = new StringBuilder("Error during processing of datagram:\n");
            Utils.hexDump(buffer, this.data, this.length);
            log.error((Object)buffer.toString(), (Throwable)ex);
        }
    }
}

