/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;

public class SynchronousCallback {
    private MessageContext outMessageContext;
    private MessageContext inMessageContext;
    private boolean isComplete;

    public SynchronousCallback(MessageContext outMessageContext) {
        this.outMessageContext = outMessageContext;
        this.isComplete = false;
    }

    public synchronized void setInMessageContext(MessageContext inMessageContext) throws AxisFault {
        if (!this.isComplete) {
            inMessageContext.getEnvelope().build();
            OperationContext operationContext = this.outMessageContext.getOperationContext();
            MessageContext msgCtx = operationContext.getMessageContext("In");
            if (msgCtx == null) {
                if (this.outMessageContext.getProperty("piggybackMessage") != null) {
                    msgCtx = (MessageContext)this.outMessageContext.getProperty("piggybackMessage");
                    msgCtx.setTransportIn(inMessageContext.getTransportIn());
                    msgCtx.setTransportOut(inMessageContext.getTransportOut());
                    msgCtx.setServerSide(false);
                    msgCtx.setProperty("mail.contenttype", inMessageContext.getProperty("mail.contenttype"));
                    msgCtx.setIncomingTransportName("mailto");
                    msgCtx.setEnvelope(inMessageContext.getEnvelope());
                } else {
                    inMessageContext.setOperationContext(operationContext);
                    inMessageContext.setServiceContext(this.outMessageContext.getServiceContext());
                    if (!operationContext.isComplete()) {
                        operationContext.addMessageContext(inMessageContext);
                    }
                    AxisOperation axisOp = operationContext.getAxisOperation();
                    AxisMessage inMessage = axisOp.getMessage("In");
                    inMessageContext.setAxisMessage(inMessage);
                    inMessageContext.setServerSide(false);
                }
            } else {
                msgCtx.setOperationContext(operationContext);
                msgCtx.setServiceContext(this.outMessageContext.getServiceContext());
                AxisOperation axisOp = operationContext.getAxisOperation();
                AxisMessage inMessage = axisOp.getMessage("In");
                msgCtx.setAxisMessage(inMessage);
                msgCtx.setTransportIn(inMessageContext.getTransportIn());
                msgCtx.setTransportOut(inMessageContext.getTransportOut());
                msgCtx.setServerSide(false);
                msgCtx.setProperty("mail.contenttype", inMessageContext.getProperty("mail.contenttype"));
                msgCtx.setIncomingTransportName("mailto");
                msgCtx.setEnvelope(inMessageContext.getEnvelope());
            }
            this.inMessageContext = inMessageContext;
            this.isComplete = true;
            this.notifyAll();
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean complete) {
        this.isComplete = complete;
    }
}

