/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMException;

public class TextFromElementReader
extends Reader {
    private final XMLStreamReader stream;
    private boolean endOfStream;
    private int skipDepth;
    private int sourceStart = -1;

    public TextFromElementReader(XMLStreamReader stream) {
        this.stream = stream;
        try {
            if (stream.getEventType() != 7) {
                throw new OMException("Expected START_DOCUMENT as first event from parser");
            }
            if (stream.next() != 1) {
                throw new OMException("Expected START_ELEMENT event");
            }
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int read = 0;
        try {
            while (true) {
                if (this.sourceStart == -1) {
                    block8: while (true) {
                        int type = this.stream.next();
                        switch (type) {
                            case 4: 
                            case 12: {
                                if (this.skipDepth != 0) break;
                                this.sourceStart = 0;
                                break block8;
                            }
                            case 1: {
                                ++this.skipDepth;
                                break;
                            }
                            case 2: {
                                if (this.skipDepth == 0) {
                                    if (this.stream.next() != 8) throw new IOException("End of document expected after element");
                                    this.endOfStream = true;
                                    this.stream.close();
                                    if (read == 0) {
                                        return -1;
                                    }
                                    int n = read;
                                    return n;
                                }
                                --this.skipDepth;
                            }
                        }
                    }
                }
                int c = this.stream.getTextCharacters(this.sourceStart, cbuf, off, len);
                this.sourceStart += c;
                off += c;
                read += c;
                if ((len -= c) <= 0) return read;
                this.sourceStart = -1;
            }
        }
        catch (XMLStreamException ex) {
            IOException ex2 = new IOException("Got an exception from the underlying parser while reading the content of an element");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    public void close() throws IOException {
        if (!this.endOfStream) {
            try {
                this.stream.close();
            }
            catch (XMLStreamException ex) {
                IOException ex2 = new IOException("Error when trying to close underlying parser");
                ex2.initCause(ex);
                throw ex2;
            }
        }
    }
}

