/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.format.DataSourceMessageBuilder;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.commons.io.IOUtils;

public class BinaryBuilder
implements DataSourceMessageBuilder {
    public OMElement processDocument(DataSource dataSource, String contentType, MessageContext msgContext) throws AxisFault {
        Parameter wrapperParam;
        QName wrapperQName = BaseConstants.DEFAULT_BINARY_WRAPPER;
        if (msgContext.getAxisService() != null && (wrapperParam = msgContext.getAxisService().getParameter("Wrapper")) != null) {
            wrapperQName = BaseUtils.getQNameFromString(wrapperParam.getValue());
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement wrapper = factory.createOMElement(wrapperQName, null);
        DataHandler dataHandler = new DataHandler(dataSource);
        wrapper.addChild(factory.createOMText(dataHandler, true));
        msgContext.setDoingMTOM(true);
        return wrapper;
    }

    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext msgContext) throws AxisFault {
        byte[] msgBytes;
        try {
            msgBytes = IOUtils.toByteArray(inputStream);
        }
        catch (IOException ex) {
            throw new AxisFault("Unable to read message payload", ex);
        }
        return this.processDocument(new ByteArrayDataSource(msgBytes), contentType, msgContext);
    }
}

