/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;

public class DescriptionBuilder
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog(DescriptionBuilder.class);
    protected ConfigurationContext configCtx;
    protected AxisConfiguration axisConfig;
    protected InputStream descriptionStream;

    public DescriptionBuilder() {
    }

    public DescriptionBuilder(InputStream serviceInputStream, ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.descriptionStream = serviceInputStream;
        this.axisConfig = this.configCtx.getAxisConfiguration();
    }

    public DescriptionBuilder(InputStream serviceInputStream, AxisConfiguration axisConfig) {
        this.descriptionStream = serviceInputStream;
        this.axisConfig = axisConfig;
    }

    public OMElement buildOM() throws XMLStreamException {
        OMElement element = (OMElement)XMLUtils.toOM(this.descriptionStream);
        element.build();
        return element;
    }

    protected MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/ns/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        return this.axisConfig.getMessageReceiver(mepURL);
    }

    protected HashMap processMessageReceivers(OMElement messageReceivers) throws DeploymentException {
        HashMap<String, MessageReceiver> mr_mep = new HashMap<String, MessageReceiver>();
        Iterator msgReceivers = messageReceivers.getChildrenWithName(new QName("messageReceiver"));
        while (msgReceivers.hasNext()) {
            OMElement msgReceiver;
            final OMElement tempMsgReceiver = msgReceiver = (OMElement)msgReceivers.next();
            MessageReceiver receiver = null;
            try {
                receiver = (MessageReceiver)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws DeploymentException {
                        return DescriptionBuilder.this.loadMessageReceiver(Thread.currentThread().getContextClassLoader(), tempMsgReceiver);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (DeploymentException)e.getException();
            }
            OMAttribute mepAtt = msgReceiver.getAttribute(new QName("mep"));
            mr_mep.put(mepAtt.getAttributeValue(), receiver);
        }
        return mr_mep;
    }

    protected HashMap processMessageReceivers(ClassLoader loader, OMElement element) throws DeploymentException {
        HashMap<String, MessageReceiver> meps = new HashMap<String, MessageReceiver>();
        Iterator iterator = element.getChildrenWithName(new QName("messageReceiver"));
        while (iterator.hasNext()) {
            OMElement receiverElement = (OMElement)iterator.next();
            MessageReceiver receiver = this.loadMessageReceiver(loader, receiverElement);
            OMAttribute mepAtt = receiverElement.getAttribute(new QName("mep"));
            meps.put(mepAtt.getAttributeValue(), receiver);
        }
        return meps;
    }

    protected MessageReceiver loadMessageReceiver(ClassLoader loader, OMElement element) throws DeploymentException {
        OMAttribute receiverName = element.getAttribute(new QName("class"));
        String className = receiverName.getAttributeValue();
        MessageReceiver receiver = null;
        try {
            if (className != null && !"".equals(className)) {
                Class messageReceiver = Loader.loadClass(loader, className);
                receiver = (MessageReceiver)messageReceiver.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(Messages.getMessage("errorinloadingmr", "ClassNotFoundException", className), e);
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(Messages.getMessage("errorinloadingmr", "IllegalAccessException", className), e);
        }
        catch (InstantiationException e) {
            throw new DeploymentException(Messages.getMessage("errorinloadingmr", "InstantiationException", className), e);
        }
        return receiver;
    }

    protected HashMap processMessageBuilders(OMElement messageBuildersElement) throws DeploymentException {
        HashMap<String, Builder> builderSelector = new HashMap<String, Builder>();
        Iterator msgBuilders = messageBuildersElement.getChildrenWithName(new QName("messageBuilder"));
        while (msgBuilders.hasNext()) {
            Builder builderObject;
            OMElement msgBuilderElement = (OMElement)msgBuilders.next();
            OMAttribute builderName = msgBuilderElement.getAttribute(new QName("class"));
            String className = builderName.getAttributeValue();
            Class builderClass = null;
            try {
                builderClass = this.findAndValidateSelectorClass(className, "errorloadingbuilder");
                builderObject = (Builder)builderClass.newInstance();
            }
            catch (PrivilegedActionException e) {
                throw (DeploymentException)e.getException();
            }
            catch (InstantiationException e) {
                throw new DeploymentException("Cannot instantiate the specified Builder Class  : " + builderClass.getName() + ".", e);
            }
            catch (IllegalAccessException e) {
                throw new DeploymentException("Cannot instantiate the specified Builder Class : " + builderClass.getName() + ".", e);
            }
            OMAttribute contentTypeAtt = msgBuilderElement.getAttribute(new QName("contentType"));
            builderSelector.put(contentTypeAtt.getAttributeValue(), builderObject);
        }
        return builderSelector;
    }

    protected HashMap processMessageFormatters(OMElement messageFormattersElement) throws DeploymentException {
        HashMap<String, MessageFormatter> messageFormatters = new HashMap<String, MessageFormatter>();
        Iterator msgFormatters = messageFormattersElement.getChildrenWithName(new QName("messageFormatter"));
        while (msgFormatters.hasNext()) {
            MessageFormatter formatterObject;
            OMElement msgFormatterElement;
            OMElement tempMsgFormatter = msgFormatterElement = (OMElement)msgFormatters.next();
            OMAttribute formatterName = tempMsgFormatter.getAttribute(new QName("class"));
            String className = formatterName.getAttributeValue();
            Class formatterClass = null;
            try {
                formatterClass = this.findAndValidateSelectorClass(className, "errorloadingformatter");
                formatterObject = (MessageFormatter)formatterClass.newInstance();
            }
            catch (PrivilegedActionException e) {
                throw (DeploymentException)e.getException();
            }
            catch (InstantiationException e) {
                throw new DeploymentException("Cannot instantiate the specified Formatter Class  : " + formatterClass.getName() + ".", e);
            }
            catch (IllegalAccessException e) {
                throw new DeploymentException("Cannot instantiate the specified Formatter Class : " + formatterClass.getName() + ".", e);
            }
            OMAttribute contentTypeAtt = msgFormatterElement.getAttribute(new QName("contentType"));
            messageFormatters.put(contentTypeAtt.getAttributeValue(), formatterObject);
        }
        return messageFormatters;
    }

    protected Class findAndValidateSelectorClass(final String className, final String errorMsg) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws DeploymentException {
                Class selectorClass;
                try {
                    if (className == null || "".equals(className)) {
                        throw new DeploymentException(Messages.getMessage(errorMsg, "Invalid Class Name", className));
                    }
                    selectorClass = Loader.loadClass(Thread.currentThread().getContextClassLoader(), className);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException(Messages.getMessage(errorMsg, "ClassNotFoundException", className), e);
                }
                return selectorClass;
            }
        });
    }

    protected Flow processFlow(OMElement flowelement, ParameterInclude parent) throws DeploymentException {
        Flow flow = new Flow();
        if (flowelement == null) {
            return flow;
        }
        Iterator handlers = flowelement.getChildrenWithName(new QName("handler"));
        while (handlers.hasNext()) {
            OMElement handlerElement = (OMElement)handlers.next();
            flow.addHandler(this.processHandler(handlerElement, parent));
        }
        return flow;
    }

    protected String[] processSupportedPolicyNamespaces(OMElement supportedPolicyElements) {
        String value;
        OMAttribute namespaces = supportedPolicyElements.getAttribute(new QName("namespaces"));
        if (namespaces != null && (value = namespaces.getAttributeValue()).trim().length() != 0) {
            return value.split(" ");
        }
        return null;
    }

    protected QName[] getLocalPolicyAssertionNames(OMElement localPolicyAssertionsElement) {
        Iterator iterator = localPolicyAssertionsElement.getChildElements();
        if (!iterator.hasNext()) {
            return null;
        }
        ArrayList<QName> qnames = new ArrayList<QName>();
        while (iterator.hasNext()) {
            OMElement childElement = (OMElement)iterator.next();
            qnames.add(childElement.getQName());
        }
        QName[] buffer = new QName[qnames.size()];
        System.arraycopy(qnames.toArray(), 0, buffer, 0, qnames.size());
        return buffer;
    }

    protected HandlerDescription processHandler(OMElement handler_element, ParameterInclude parent) throws DeploymentException {
        return this.processHandler(handler_element, parent, null);
    }

    protected HandlerDescription processHandler(OMElement handler_element, ParameterInclude parent, String containingPhase) throws DeploymentException {
        OMAttribute name_attribute = handler_element.getAttribute(new QName("name"));
        if (name_attribute == null || name_attribute.getAttributeValue().equals("")) {
            throw new DeploymentException(Messages.getMessage("invalidhandler", "Unknown", "Name missing"));
        }
        HandlerDescription handler = new HandlerDescription(name_attribute.getAttributeValue());
        OMAttribute class_attribute = handler_element.getAttribute(new QName("class"));
        if (class_attribute == null) {
            throw new DeploymentException(Messages.getMessage("invalidhandler", name_attribute.getAttributeValue(), "class name is missing"));
        }
        handler.setClassName(class_attribute.getAttributeValue());
        OMElement order_element = handler_element.getFirstChildWithName(new QName("order"));
        PhaseRule rules = handler.getRules();
        if (order_element == null) {
            if (containingPhase == null) {
                throw new DeploymentException(Messages.getMessage("invalidhandler", name_attribute.getAttributeValue(), "phase rule has not been specified"));
            }
            rules.setPhaseName(containingPhase);
        } else {
            Iterator order_itr = order_element.getAllAttributes();
            while (order_itr.hasNext()) {
                String boolval;
                OMAttribute orderAttribute = (OMAttribute)order_itr.next();
                String name = orderAttribute.getQName().getLocalPart();
                String value = orderAttribute.getAttributeValue();
                if ("after".equals(name)) {
                    rules.setAfter(value);
                    continue;
                }
                if ("before".equals(name)) {
                    rules.setBefore(value);
                    continue;
                }
                if ("phase".equals(name)) {
                    rules.setPhaseName(value);
                    continue;
                }
                if ("phaseFirst".equals(name)) {
                    boolval = this.getValue(value);
                    if (boolval.equals("true")) {
                        rules.setPhaseFirst(true);
                        continue;
                    }
                    if (!boolval.equals("false")) continue;
                    rules.setPhaseFirst(false);
                    continue;
                }
                if (!"phaseLast".equals(name)) continue;
                boolval = this.getValue(value);
                if (boolval.equals("true")) {
                    rules.setPhaseLast(true);
                    continue;
                }
                if (!boolval.equals("false")) continue;
                rules.setPhaseLast(false);
            }
            Iterator parameters = handler_element.getChildrenWithName(new QName("parameter"));
            try {
                this.processParameters(parameters, handler, parent);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
        }
        handler.setParent(parent);
        return handler;
    }

    protected void processOperationModuleRefs(Iterator moduleRefs, AxisOperation operation) throws DeploymentException {
        try {
            while (moduleRefs.hasNext()) {
                OMElement moduleref = (OMElement)moduleRefs.next();
                OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
                if (moduleRefAttribute == null) continue;
                String refName = moduleRefAttribute.getAttributeValue();
                if (this.axisConfig.getModule(refName) == null) {
                    throw new DeploymentException(Messages.getMessage("modulenotfound", refName));
                }
                operation.addModule(refName);
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(Messages.getMessage("modulenotfound", axisFault.getMessage()), axisFault);
        }
    }

    protected void processParameters(Iterator parameters, ParameterInclude parameterInclude, ParameterInclude parent) throws DeploymentException {
        while (parameters.hasNext()) {
            OMElement parameterElement = (OMElement)parameters.next();
            Parameter parameter = new Parameter();
            parameter.setParameterElement(parameterElement);
            OMAttribute paramName = parameterElement.getAttribute(new QName("name"));
            if (paramName == null) {
                throw new DeploymentException(Messages.getMessage("badparaagu", ((Object)parameterElement).toString()));
            }
            parameter.setName(paramName.getAttributeValue());
            OMElement paramValue = parameterElement.getFirstElement();
            if (paramValue != null) {
                parameter.setValue(parameterElement);
                parameter.setParameterType(2);
            } else {
                String paratextValue = parameterElement.getText();
                parameter.setValue(paratextValue);
                parameter.setParameterType(1);
            }
            OMAttribute paramLocked = parameterElement.getAttribute(new QName("locked"));
            Parameter parentParam = null;
            if (parent != null) {
                parentParam = parent.getParameter(parameter.getName());
            }
            if (paramLocked != null) {
                String lockedValue = paramLocked.getAttributeValue();
                if ("true".equals(lockedValue)) {
                    if (parent != null && parent.isParameterLocked(parameter.getName())) {
                        throw new DeploymentException(Messages.getMessage("confignotfound", parameter.getName()));
                    }
                    parameter.setLocked(true);
                } else {
                    parameter.setLocked(false);
                }
            }
            try {
                if (parent != null) {
                    if (parentParam != null && parent.isParameterLocked(parameter.getName())) continue;
                    parameterInclude.addParameter(parameter);
                    continue;
                }
                parameterInclude.addParameter(parameter);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
        }
    }

    protected void processActionMappings(OMElement operation, AxisOperation op_descrip) {
        Iterator mappingIterator = operation.getChildrenWithName(new QName("actionMapping"));
        ArrayList<String> mappingList = new ArrayList<String>();
        while (mappingIterator.hasNext()) {
            OMElement mappingElement = (OMElement)mappingIterator.next();
            String inputActionString = mappingElement.getText().trim();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Input Action Mapping found: " + inputActionString));
            }
            if (!"".equals(inputActionString)) {
                mappingList.add(inputActionString);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)"Zero length input action string found. Not added to mapping");
        }
        op_descrip.setWsamappingList(mappingList);
        OMElement outputAction = operation.getFirstChildWithName(new QName("outputActionMapping"));
        if (outputAction != null && outputAction.getText() != null) {
            String outputActionString = outputAction.getText().trim();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Output Action Mapping found: " + outputActionString));
            }
            op_descrip.setOutputAction(outputActionString);
        }
        Iterator faultActionsIterator = operation.getChildrenWithName(new QName("faultActionMapping"));
        while (faultActionsIterator.hasNext()) {
            OMElement faultMappingElement = (OMElement)faultActionsIterator.next();
            String faultActionString = faultMappingElement.getText().trim();
            String faultActionName = faultMappingElement.getAttributeValue(new QName("faultName"));
            if (faultActionName == null || faultActionString == null) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Fault Action Mapping found: " + faultActionName + ", " + faultActionString));
            }
            op_descrip.addFaultAction(faultActionName, faultActionString);
        }
    }

    protected void processPolicyElements(Iterator policyElements, PolicySubject policySubject) {
        while (policyElements.hasNext()) {
            Policy p = PolicyEngine.getPolicy((OMElement)policyElements.next());
            policySubject.attachPolicy(p);
        }
    }

    protected void processPolicyRefElements(Iterator policyRefElements, PolicySubject policySubject) {
        while (policyRefElements.hasNext()) {
            PolicyReference policyReference = PolicyEngine.getPolicyReference((OMElement)policyRefElements.next());
            policySubject.attachPolicyReference(policyReference);
        }
    }

    public static String getShortFileName(String fileName) {
        int seperator = 46;
        int index = fileName.lastIndexOf(seperator);
        if (index > 0) {
            String value = fileName.substring(0, index);
            return value;
        }
        return fileName;
    }

    protected String getValue(String in) {
        int seperator = 58;
        int index = in.indexOf(seperator);
        if (index > 0) {
            String value = in.substring(index + 1, in.length());
            return value;
        }
        return in;
    }
}

