/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.externalize.ExternalizeConstants;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageExternalizeUtils
implements ExternalizeConstants {
    static final Log log = LogFactory.getLog(MessageExternalizeUtils.class);
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;

    private MessageExternalizeUtils() {
    }

    public static void writeExternal(ObjectOutput out, MessageContext mc, String correlationIDString, OMOutputFormat outputFormat) throws IOException {
        SOAPEnvelope envelope;
        if (log.isDebugEnabled()) {
            log.debug((Object)(correlationIDString + ":writeExternal(): start"));
        }
        if ((envelope = mc.getEnvelope()) == null) {
            out.writeUTF("NULL_ENVELOPE");
            out.writeInt(2);
            out.writeBoolean(false);
            out.writeInt(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)(correlationIDString + ":writeExternal(): end: msg is Empty"));
            }
            return;
        }
        String msgClass = envelope.getClass().getName();
        out.writeUTF(msgClass);
        out.writeInt(2);
        out.writeBoolean(true);
        if (outputFormat.isOptimized()) {
            out.writeBoolean(true);
            out.writeUTF(outputFormat.getContentType());
        } else {
            out.writeBoolean(false);
        }
        out.writeUTF(outputFormat.getCharSetEncoding());
        out.writeUTF(envelope.getNamespace().getNamespaceURI());
        if (log.isDebugEnabled()) {
            log.debug((Object)(correlationIDString + ":writeExternal(): " + "optimized=[" + outputFormat.isOptimized() + "]  " + "optimizedContentType " + outputFormat.getContentType() + "]  " + "charSetEnc=[" + outputFormat.getCharSetEncoding() + "]  " + "namespaceURI=[" + envelope.getNamespace().getNamespaceURI() + "]"));
        }
        MessageOutputStream mos = new MessageOutputStream(out);
        BufferedOutputStream bos = new BufferedOutputStream(mos);
        boolean errorOccurred = false;
        try {
            try {
                MessageFormatter msgFormatter = TransportUtils.getMessageFormatter(mc);
                msgFormatter.writeTo(mc, outputFormat, bos, true);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw AxisFault.makeFault(t);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            bos.flush();
            bos.close();
            throw throwable;
        }
        bos.flush();
        bos.close();
        if (errorOccurred) {
            out.writeInt(-1);
        } else {
            out.writeInt(0);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(correlationIDString + ":writeExternal(): end"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SOAPEnvelope readExternal(ObjectInput in, MessageContext mc, String correlationIDString) throws IOException, ClassNotFoundException {
        MessageInputStream mis;
        SOAPEnvelope envelope;
        block17: {
            if (log.isDebugEnabled()) {
                log.debug((Object)(correlationIDString + ":readExternal(): start"));
            }
            envelope = null;
            String name = in.readUTF();
            int revision = in.readInt();
            if (log.isDebugEnabled()) {
                log.debug((Object)(correlationIDString + ":readExternal(): name= " + name + " revision= " + revision));
            }
            if (revision != 2) {
                throw new ClassNotFoundException("Revision ID is not supported.");
            }
            boolean gotMsg = in.readBoolean();
            if (!gotMsg) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(correlationIDString + ":readExternal(): end:" + "no message present"));
                }
                in.readInt();
                return envelope;
            }
            boolean optimized = in.readBoolean();
            String optimizedContentType = null;
            if (optimized) {
                optimizedContentType = in.readUTF();
            }
            String charSetEnc = in.readUTF();
            String namespaceURI = in.readUTF();
            if (log.isDebugEnabled()) {
                log.debug((Object)(correlationIDString + ":readExternal(): " + "optimized=[" + optimized + "]  " + "optimizedContentType=[" + optimizedContentType + "]  " + "charSetEnc=[" + charSetEnc + "]  " + "namespaceURI=[" + namespaceURI + "]"));
            }
            mis = new MessageInputStream(in);
            StAXBuilder builder = null;
            try {
                try {
                    if (optimized) {
                        boolean isSOAP = true;
                        builder = BuilderUtil.getAttachmentsBuilder(mc, mis, optimizedContentType, isSOAP);
                        envelope = (SOAPEnvelope)builder.getDocumentElement();
                        envelope.buildWithAttachments();
                    } else {
                        XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader(mis, charSetEnc);
                        builder = new StAXSOAPModelBuilder(xmlreader, namespaceURI);
                        envelope = (SOAPEnvelope)builder.getDocumentElement();
                        envelope.build();
                    }
                }
                catch (Exception ex) {
                    log.error((Object)(correlationIDString + ":readExternal(): Error when deserializing persisted envelope: [" + ex.getClass().getName() + " : " + ex.getLocalizedMessage() + "]"), (Throwable)ex);
                    envelope = null;
                    Object var15_17 = null;
                    if (builder != null) {
                        builder.close();
                    }
                    mis.close();
                    if (!log.isDebugEnabled()) return envelope;
                    log.debug((Object)(correlationIDString + ":readExternal(): end"));
                    return envelope;
                }
                Object var15_16 = null;
                if (builder == null) break block17;
                builder.close();
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (builder != null) {
                    builder.close();
                }
                mis.close();
                if (!log.isDebugEnabled()) throw throwable;
                log.debug((Object)(correlationIDString + ":readExternal(): end"));
                throw throwable;
            }
        }
        mis.close();
        if (!log.isDebugEnabled()) return envelope;
        log.debug((Object)(correlationIDString + ":readExternal(): end"));
        return envelope;
    }

    private static class MessageInputStream
    extends InputStream {
        ObjectInput in;
        boolean isDebug;
        int chunkAvail = 0;
        boolean isEOD = false;

        MessageInputStream(ObjectInput in) {
            this.in = in;
            this.isDebug = log.isDebugEnabled();
        }

        public int read() throws IOException {
            if (this.isDebug) {
                log.debug((Object)"invoking read()");
            }
            this.updateChunkAvail();
            int ret = 0;
            if (this.isEOD) {
                ret = -1;
            } else {
                --this.chunkAvail;
                ret = this.in.readByte();
            }
            log.debug((Object)("returning " + ret));
            return ret;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.isDebug) {
                log.debug((Object)("invoking read with off=" + off + " and len=" + len));
            }
            if (this.isEOD) {
                if (this.isDebug) {
                    log.debug((Object)"EOD returning -1");
                }
                return -1;
            }
            int bytesRead = 0;
            while (len > 0 && !this.isEOD) {
                this.updateChunkAvail();
                if (this.isEOD) continue;
                int readLength = len < this.chunkAvail ? len : this.chunkAvail;
                int br = this.in.read(b, off, readLength);
                if (br < 0) {
                    throw new IOException("End of File encountered");
                }
                off += br;
                len -= br;
                this.chunkAvail -= br;
                bytesRead += br;
            }
            if (this.isDebug) {
                log.debug((Object)("bytes read = " + bytesRead));
            }
            return bytesRead;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public void close() throws IOException {
            if (this.isDebug) {
                log.debug((Object)"start close");
            }
            if (!this.isEOD) {
                byte[] tempBuffer = new byte[4096];
                while (!this.isEOD) {
                    this.read(tempBuffer);
                }
            }
            if (this.isDebug) {
                log.debug((Object)"end close");
            }
        }

        private void updateChunkAvail() throws IOException {
            if (this.chunkAvail == 0 && !this.isEOD) {
                this.chunkAvail = this.in.readInt();
                if (this.isDebug) {
                    log.debug((Object)("New DataBlock with size=" + this.chunkAvail));
                }
                if (this.chunkAvail <= 0) {
                    if (this.isDebug) {
                        log.debug((Object)"End of data");
                    }
                    this.isEOD = true;
                    this.chunkAvail = 0;
                }
            }
        }
    }

    private static class MessageOutputStream
    extends OutputStream {
        ObjectOutput out;
        boolean isDebug;

        MessageOutputStream(ObjectOutput out) {
            this.out = out;
            this.isDebug = log.isDebugEnabled();
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                if (this.isDebug) {
                    log.debug((Object)("Write data chunk with len=" + len));
                }
                this.out.writeInt(len);
                this.out.write(b, off, len);
            }
        }

        public void write(byte[] b) throws IOException {
            if (b != null && b.length > 0) {
                if (this.isDebug) {
                    log.debug((Object)("Write data chunk with size=" + b.length));
                }
                this.out.writeInt(b.length);
                this.out.write(b);
            }
        }

        public void write(int b) throws IOException {
            if (this.isDebug) {
                log.debug((Object)"Write one byte data chunk");
            }
            this.out.writeInt(1);
            this.out.write(b);
        }
    }
}

