/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OMNodeImpl
implements OMNode,
OMNodeEx {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$axiom$om$impl$llom$OMNodeImpl == null ? (class$org$apache$axiom$om$impl$llom$OMNodeImpl = OMNodeImpl.class$("org.apache.axiom.om.impl.llom.OMNodeImpl")) : class$org$apache$axiom$om$impl$llom$OMNodeImpl));
    private static boolean DEBUG_ENABLED = log.isDebugEnabled();
    protected OMContainerEx parent;
    protected OMNodeImpl nextSibling;
    protected OMNodeImpl previousSibling;
    public OMXMLParserWrapper builder;
    protected boolean done = false;
    protected int nodeType;
    protected OMFactory factory;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$llom$OMNodeImpl;

    public OMNodeImpl(OMFactory factory) {
        this.factory = factory;
    }

    public OMNodeImpl(OMContainer parent, OMFactory factory, boolean done) {
        this.done = done;
        this.factory = factory;
        if (parent != null) {
            this.parent = (OMContainerEx)parent;
            parent.addChild(this);
        }
    }

    public OMContainer getParent() {
        return this.parent;
    }

    public void setParent(OMContainer element) {
        if (this.parent == element) {
            return;
        }
        if (element != null) {
            if (this.parent != null) {
                this.detach();
            }
            this.parent = (OMContainerEx)element;
        } else {
            this.parent = null;
        }
    }

    public OMNode getNextOMSibling() throws OMException {
        if (this.nextSibling == null && this.parent != null && !this.parent.isComplete()) {
            this.parent.buildNext();
        }
        return this.nextSibling;
    }

    public void setNextOMSibling(OMNode node) {
        this.nextSibling = node == null || node.getOMFactory() instanceof OMLinkedListImplFactory ? (OMNodeImpl)node : (OMNodeImpl)this.importNode(node);
        this.nextSibling = (OMNodeImpl)node;
    }

    public boolean isComplete() {
        return this.done;
    }

    public void setComplete(boolean state) {
        this.done = state;
        if (this.parent != null) {
            if (!this.done) {
                this.parent.setComplete(false);
            } else if (this.parent instanceof OMElementImpl) {
                ((OMElementImpl)this.parent).notifyChildComplete();
            }
        }
    }

    public OMNode detach() throws OMException {
        if (this.parent == null) {
            throw new OMException("Elements that doesn't have a parent can not be detached");
        }
        OMNodeImpl nextSibling = (OMNodeImpl)this.getNextOMSibling();
        if (this.previousSibling == null) {
            this.parent.setFirstChild(nextSibling);
        } else {
            ((OMNodeEx)this.getPreviousOMSibling()).setNextOMSibling(nextSibling);
        }
        if (nextSibling != null) {
            nextSibling.setPreviousOMSibling(this.getPreviousOMSibling());
        }
        if (this.parent instanceof OMElementImpl && ((OMElementImpl)this.parent).lastChild == this) {
            ((OMElementImpl)this.parent).lastChild = this.getPreviousOMSibling();
        }
        this.previousSibling = null;
        this.nextSibling = null;
        this.parent = null;
        return this;
    }

    public void insertSiblingAfter(OMNode sibling) throws OMException {
        if (this.parent == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        ((OMNodeEx)sibling).setParent(this.parent);
        if (sibling instanceof OMNodeImpl) {
            OMNodeImpl siblingImpl = (OMNodeImpl)sibling;
            if (this.nextSibling == null) {
                this.getNextOMSibling();
            }
            siblingImpl.setPreviousOMSibling(this);
            if (this.nextSibling == null) {
                this.parent.setLastChild(sibling);
            } else {
                this.nextSibling.setPreviousOMSibling(sibling);
            }
            ((OMNodeEx)sibling).setNextOMSibling(this.nextSibling);
            this.nextSibling = siblingImpl;
        }
    }

    public void insertSiblingBefore(OMNode sibling) throws OMException {
        if (this.parent == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        if (sibling instanceof OMNodeImpl) {
            OMNodeImpl siblingImpl = (OMNodeImpl)sibling;
            if (this.previousSibling == null) {
                this.parent.setFirstChild(siblingImpl);
                siblingImpl.nextSibling = this;
                siblingImpl.previousSibling = null;
            } else {
                siblingImpl.setParent(this.parent);
                siblingImpl.nextSibling = this;
                this.previousSibling.setNextOMSibling(siblingImpl);
                siblingImpl.setPreviousOMSibling(this.previousSibling);
            }
            this.previousSibling = siblingImpl;
        }
    }

    public int getType() {
        return this.nodeType;
    }

    public void setType(int nodeType) throws OMException {
        this.nodeType = nodeType;
    }

    public OMNode getPreviousOMSibling() {
        return this.previousSibling;
    }

    public void setPreviousOMSibling(OMNode previousSibling) {
        this.previousSibling = previousSibling == null || previousSibling.getOMFactory() instanceof OMLinkedListImplFactory ? (OMNodeImpl)previousSibling : (OMNodeImpl)this.importNode(previousSibling);
    }

    public void build() throws OMException {
        if (this.builder != null && this.builder.isCompleted() && DEBUG_ENABLED) {
            log.debug((Object)"Builder is already complete.");
        }
        while (!this.done) {
            this.builder.next();
            if (!this.builder.isCompleted() || this.done) continue;
            if (DEBUG_ENABLED) {
                log.debug((Object)"Builder is complete.  Setting OMNode to complete.");
            }
            this.setComplete(true);
        }
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
    }

    public void close(boolean build) {
        if (build) {
            this.build();
        }
        this.done = true;
        if (this.builder instanceof StAXBuilder && !((StAXBuilder)this.builder).isClosed()) {
            ((StAXBuilder)this.builder).releaseParserOnClose(true);
            ((StAXBuilder)this.builder).close();
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        MTOMXMLStreamWriter writer = xmlWriter instanceof MTOMXMLStreamWriter ? (MTOMXMLStreamWriter)xmlWriter : new MTOMXMLStreamWriter(xmlWriter);
        this.internalSerialize(writer);
        writer.flush();
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        MTOMXMLStreamWriter writer = xmlWriter instanceof MTOMXMLStreamWriter ? (MTOMXMLStreamWriter)xmlWriter : new MTOMXMLStreamWriter(xmlWriter);
        this.internalSerializeAndConsume(writer);
        writer.flush();
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        throw new RuntimeException("Not implemented yet!");
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        throw new RuntimeException("Not implemented yet!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(OutputStream output) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(output);
        try {
            this.serialize(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Writer writer) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(writer);
        try {
            this.serialize(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(output);
        try {
            this.serializeAndConsume(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(writer);
        try {
            this.serializeAndConsume(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerialize(writer);
        writer.flush();
        if (format.isAutoCloseWriter()) {
            writer.close();
        }
    }

    public void serialize(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter(writer2));
        writer.setOutputFormat(format);
        this.internalSerialize(writer);
        writer.flush();
        if (format.isAutoCloseWriter()) {
            writer.close();
        }
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerializeAndConsume(writer);
        writer.flush();
        if (format.isAutoCloseWriter()) {
            writer.close();
        }
    }

    public void serializeAndConsume(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter(writer2));
        writer.setOutputFormat(format);
        this.internalSerializeAndConsume(writer);
        writer.flush();
        if (format.isAutoCloseWriter()) {
            writer.close();
        }
    }

    public OMFactory getOMFactory() {
        return this.factory;
    }

    protected OMNode importNode(OMNode child) {
        int type = child.getType();
        switch (type) {
            case 1: {
                OMElement childElement = (OMElement)child;
                OMElement newElement = new StAXOMBuilder(this.factory, childElement.getXMLStreamReader()).getDocumentElement();
                newElement.buildWithAttachments();
                return newElement;
            }
            case 4: {
                OMText newText;
                OMText importedText = (OMText)child;
                if (importedText.isBinary()) {
                    boolean isOptimize = importedText.isOptimized();
                    newText = this.factory.createOMText(importedText.getDataHandler(), isOptimize);
                } else {
                    newText = importedText.isCharacters() ? this.factory.createOMText(null, importedText.getTextCharacters(), importedText.getType()) : this.factory.createOMText(null, importedText.getText());
                }
                return newText;
            }
            case 3: {
                OMProcessingInstruction importedPI = (OMProcessingInstruction)child;
                return this.factory.createOMProcessingInstruction(null, importedPI.getTarget(), importedPI.getValue());
            }
            case 5: {
                OMComment importedComment = (OMComment)child;
                return this.factory.createOMComment(null, importedComment.getValue());
            }
            case 11: {
                OMDocType importedDocType = (OMDocType)child;
                return this.factory.createOMDocType(null, importedDocType.getValue());
            }
        }
        throw new UnsupportedOperationException("Not Implemented Yet for the given node type");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

