/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.tubemq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.tubemq.TubemqTableSink;
import org.apache.flink.connectors.tubemq.TubemqTableSource;
import org.apache.flink.connectors.tubemq.TubemqValidator;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.types.Row;

public class TubemqTableSourceSinkFactory
implements StreamTableSourceFactory<Row>,
StreamTableSinkFactory<Row> {
    private static final String SPLIT_COMMA = ",";

    private TubemqTableSourceSinkFactory() {
    }

    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("update-mode", "append");
        context.put("connector.type", "tubemq");
        context.put("connector.property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("connector.topic");
        properties.add("connector.master");
        properties.add("connector.group");
        properties.add("connector.tids");
        properties.add("connector.properties.*");
        properties.add("schema.#.type");
        properties.add("schema.#.name");
        properties.add("schema.#.from");
        properties.add("schema.#.proctime");
        properties.add("schema.#.rowtime.timestamps.type");
        properties.add("schema.#.rowtime.timestamps.from");
        properties.add("schema.#.rowtime.timestamps.class");
        properties.add("schema.#.rowtime.timestamps.serialized");
        properties.add("schema.#.rowtime.watermarks.type");
        properties.add("schema.#.rowtime.watermarks.class");
        properties.add("schema.#.rowtime.watermarks.serialized");
        properties.add("schema.#.rowtime.watermarks.delay");
        properties.add("format.*");
        return properties;
    }

    public StreamTableSource<Row> createStreamTableSource(Map<String, String> properties) {
        DeserializationSchema<Row> deserializationSchema = this.getDeserializationSchema(properties);
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        this.validateProperties(descriptorProperties);
        TableSchema schema = descriptorProperties.getTableSchema("schema");
        Optional proctimeAttribute = SchemaValidator.deriveProctimeAttribute((DescriptorProperties)descriptorProperties);
        List rowtimeAttributeDescriptors = SchemaValidator.deriveRowtimeAttributes((DescriptorProperties)descriptorProperties);
        Map fieldMapping = SchemaValidator.deriveFieldMapping((DescriptorProperties)descriptorProperties, Optional.of(deserializationSchema.getProducedType()));
        String topic = descriptorProperties.getString("connector.topic");
        String masterAddress = descriptorProperties.getString("connector.master");
        String consumerGroup = descriptorProperties.getString("connector.group");
        String tids = descriptorProperties.getOptionalString("connector.tids").orElse(null);
        Configuration configuration = this.getConfiguration(descriptorProperties);
        TreeSet<String> tidSet = new TreeSet<String>();
        if (tids != null) {
            tidSet.addAll(Arrays.asList(tids.split(SPLIT_COMMA)));
        }
        return new TubemqTableSource(deserializationSchema, schema, proctimeAttribute, rowtimeAttributeDescriptors, fieldMapping, masterAddress, topic, tidSet, consumerGroup, configuration);
    }

    public StreamTableSink<Row> createStreamTableSink(Map<String, String> properties) {
        SerializationSchema<Row> serializationSchema = this.getSerializationSchema(properties);
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        this.validateProperties(descriptorProperties);
        TableSchema tableSchema = descriptorProperties.getTableSchema("schema");
        String topic = descriptorProperties.getString("connector.topic");
        String masterAddress = descriptorProperties.getString("connector.master");
        Configuration configuration = this.getConfiguration(descriptorProperties);
        return new TubemqTableSink(serializationSchema, tableSchema, topic, masterAddress, configuration);
    }

    private SerializationSchema<Row> getSerializationSchema(Map<String, String> properties) {
        SerializationSchemaFactory formatFactory = (SerializationSchemaFactory)TableFactoryService.find(SerializationSchemaFactory.class, properties, (ClassLoader)this.getClass().getClassLoader());
        return formatFactory.createSerializationSchema(properties);
    }

    private void validateProperties(DescriptorProperties descriptorProperties) {
        new SchemaValidator(true, false, false).validate(descriptorProperties);
        new TubemqValidator().validate(descriptorProperties);
    }

    private DeserializationSchema<Row> getDeserializationSchema(Map<String, String> properties) {
        DeserializationSchemaFactory formatFactory = (DeserializationSchemaFactory)TableFactoryService.find(DeserializationSchemaFactory.class, properties, (ClassLoader)this.getClass().getClassLoader());
        return formatFactory.createDeserializationSchema(properties);
    }

    private Configuration getConfiguration(DescriptorProperties descriptorProperties) {
        Map properties = descriptorProperties.getPropertiesWithPrefix("connector.properties");
        Configuration configuration = new Configuration();
        for (Map.Entry property : properties.entrySet()) {
            configuration.setString((String)property.getKey(), (String)property.getValue());
        }
        return configuration;
    }
}

