/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.tubemq;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.tubemq.TubemqSourceFunction;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class TubemqTableSource
implements StreamTableSource<Row>,
DefinedProctimeAttribute,
DefinedRowtimeAttributes,
DefinedFieldMapping {
    private final DeserializationSchema<Row> deserializationSchema;
    private final TableSchema schema;
    private final Optional<String> proctimeAttribute;
    private final List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors;
    private final Map<String, String> fieldMapping;
    private final String masterAddress;
    private final String topic;
    private final TreeSet<String> tidSet;
    private final String consumerGroup;
    private final Configuration configuration;

    public TubemqTableSource(DeserializationSchema<Row> deserializationSchema, TableSchema schema, Optional<String> proctimeAttribute, List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors, Map<String, String> fieldMapping, String masterAddress, String topic, TreeSet<String> tidSet, String consumerGroup, Configuration configuration) {
        Preconditions.checkNotNull(deserializationSchema, (String)"The deserialization schema must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"The schema must not be null.");
        Preconditions.checkNotNull(fieldMapping, (String)"The field mapping must not be null.");
        Preconditions.checkNotNull((Object)masterAddress, (String)"The master address must not be null.");
        Preconditions.checkNotNull((Object)topic, (String)"The topic must not be null.");
        Preconditions.checkNotNull(tidSet, (String)"The tid set must not be null.");
        Preconditions.checkNotNull((Object)consumerGroup, (String)"The consumer group must not be null.");
        Preconditions.checkNotNull((Object)configuration, (String)"The configuration must not be null.");
        this.deserializationSchema = deserializationSchema;
        this.schema = schema;
        this.fieldMapping = fieldMapping;
        this.masterAddress = masterAddress;
        this.topic = topic;
        this.tidSet = tidSet;
        this.consumerGroup = consumerGroup;
        this.configuration = configuration;
        this.proctimeAttribute = this.validateProcTimeAttribute(proctimeAttribute);
        this.rowtimeAttributeDescriptors = this.validateRowTimeAttributeDescriptors(rowtimeAttributeDescriptors);
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    @Nullable
    public String getProctimeAttribute() {
        return this.proctimeAttribute.orElse(null);
    }

    public List<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptors() {
        return this.rowtimeAttributeDescriptors;
    }

    public Map<String, String> getFieldMapping() {
        return this.fieldMapping;
    }

    public DataStream<Row> getDataStream(StreamExecutionEnvironment streamExecutionEnvironment) {
        TubemqSourceFunction<Row> sourceFunction = new TubemqSourceFunction<Row>(this.masterAddress, this.topic, this.tidSet, this.consumerGroup, this.deserializationSchema, this.configuration);
        return streamExecutionEnvironment.addSource(sourceFunction).name(this.explainSource());
    }

    private Optional<String> validateProcTimeAttribute(Optional<String> proctimeAttribute) {
        return proctimeAttribute.map(attribute -> {
            Optional tpe = this.schema.getFieldType(attribute);
            if (!tpe.isPresent()) {
                throw new ValidationException("Proc time attribute '" + attribute + "' isn't present in TableSchema.");
            }
            if (tpe.get() != Types.SQL_TIMESTAMP()) {
                throw new ValidationException("Proc time attribute '" + attribute + "' isn't of type SQL_TIMESTAMP.");
            }
            return attribute;
        });
    }

    private List<RowtimeAttributeDescriptor> validateRowTimeAttributeDescriptors(List<RowtimeAttributeDescriptor> attributeDescriptors) {
        Preconditions.checkNotNull(attributeDescriptors);
        for (RowtimeAttributeDescriptor desc : attributeDescriptors) {
            String name = desc.getAttributeName();
            Optional tpe = this.schema.getFieldType(name);
            if (!tpe.isPresent()) {
                throw new ValidationException("Row time attribute '" + name + "' is not present.");
            }
            if (tpe.get() == Types.SQL_TIMESTAMP()) continue;
            throw new ValidationException("Row time attribute '" + name + "' is not of type SQL_TIMESTAMP.");
        }
        return attributeDescriptors;
    }
}

