/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ziplock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.NamedModule;
import org.apache.ziplock.JarLocation;
import org.apache.ziplock.ResourceFinder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class WebModule {
    private final WebArchive archive;

    public WebModule(WebArchive archive) {
        this.archive = archive;
    }

    public WebModule(String name) {
        this((WebArchive)ShrinkWrap.create(WebArchive.class, (String)name));
    }

    public WebModule(Class<?> clazz, Class<?> ... excluded) {
        this(clazz, clazz.getSimpleName() + ".war", excluded);
    }

    public WebModule(Class<?> clazz, String appName, Class<?> ... excluded) {
        this(appName);
        URL archiveURL;
        try {
            File file = JarLocation.jarLocation(clazz);
            archiveURL = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        String packageName = clazz.getName().substring(0, clazz.getName().lastIndexOf(".") + 1).replace(".", "/");
        ResourceFinder finder = new ResourceFinder(archiveURL);
        try {
            Map<String, URL> map = finder.getResourcesMap(packageName);
            for (Map.Entry<String, URL> entry : map.entrySet()) {
                URL url = entry.getValue();
                String name = entry.getKey();
                if (name.endsWith(".xml")) {
                    this.archive.add((NamedAsset)new Named("WEB-INF/" + name, (Asset)new UrlAsset(url)));
                    continue;
                }
                boolean keep = true;
                if (excluded != null) {
                    for (Class<?> excludedClazz : excluded) {
                        if (!name.equals(excludedClazz.getSimpleName().concat(".class"))) continue;
                        keep = false;
                    }
                }
                if (!keep) continue;
                String path = url.getPath();
                String relativePath = path.substring(path.indexOf(packageName));
                this.archive.add((NamedAsset)new Named("WEB-INF/classes/" + relativePath, (Asset)new UrlAsset(url)));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot list package contents", e);
        }
    }

    public WebArchive getArchive() {
        return this.archive;
    }

    public static class Named
    implements NamedAsset {
        private final Asset asset;
        private final String name;

        public Named(String name, Asset asset) {
            this.asset = asset;
            this.name = name;
        }

        public InputStream openStream() {
            return this.asset.openStream();
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Descriptor<D extends NamedModule>
    implements Asset {
        private final D descriptor;

        public Descriptor(D descriptor) {
            this.descriptor = descriptor;
        }

        public InputStream openStream() {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                JaxbJavaee.marshal(this.descriptor.getClass(), this.descriptor, (OutputStream)out);
                return new ByteArrayInputStream(out.toByteArray());
            }
            catch (JAXBException e) {
                throw new IllegalArgumentException("Unable to marshal descriptor", e);
            }
        }
    }
}

