/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import javax.annotation.Resource;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import junit.framework.AssertionFailedError;
import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.stateful.PersistenceContextStatefulHome;
import org.apache.openejb.test.stateful.PersistenceContextStatefulObject;
import org.junit.Assert;

public class PersistenceContextStatefulBean {
    private EntityManager extendedEntityManager;
    private static EntityManager inheritedDelegate;
    private SessionContext ejbContext;

    @Resource
    public void setSessionContext(SessionContext ctx) {
        this.ejbContext = ctx;
    }

    @Remove
    public void remove() {
    }

    public String remove(String arg) {
        return arg;
    }

    public void testPersistenceContext() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                EntityManager em = (EntityManager)ctx.lookup("java:comp/env/persistence/TestContext");
                Assert.assertNotNull((String)"The EntityManager is null", (Object)em);
                em.getFlushMode();
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExtendedPersistenceContext() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                EntityManager em = (EntityManager)ctx.lookup("java:comp/env/persistence/ExtendedTestContext");
                Assert.assertNotNull((String)"The EntityManager is null", (Object)em);
                em.getFlushMode();
                if (this.extendedEntityManager != null) {
                    Assert.assertSame((String)"Extended entity manager should be the same instance that was found last time", (Object)this.extendedEntityManager, (Object)em);
                    Assert.assertSame((String)"Extended entity manager delegate should be the same instance that was found last time", (Object)this.extendedEntityManager.getDelegate(), (Object)em.getDelegate());
                }
                this.extendedEntityManager = em;
                UserTransaction userTransaction = this.ejbContext.getUserTransaction();
                userTransaction.begin();
                try {
                    em.getFlushMode();
                }
                finally {
                    userTransaction.commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropagatedPersistenceContext() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                EntityManager em = (EntityManager)ctx.lookup("java:comp/env/persistence/ExtendedTestContext");
                Assert.assertNotNull((String)"The EntityManager is null", (Object)em);
                em.getFlushMode();
                inheritedDelegate = (EntityManager)em.getDelegate();
                EntityManager nonExtendedEm = (EntityManager)ctx.lookup("java:comp/env/persistence/TestContext");
                nonExtendedEm.getFlushMode();
                EntityManager nonExtendedDelegate = (EntityManager)nonExtendedEm.getDelegate();
                Assert.assertTrue((String)"non-extended entity manager should be open", (boolean)nonExtendedDelegate.isOpen());
                Assert.assertNotSame((String)"Extended non-extended entity manager shound not be the same instance as extendend entity manager when accessed out side of a transactions", (Object)inheritedDelegate, (Object)nonExtendedDelegate);
                UserTransaction userTransaction = this.ejbContext.getUserTransaction();
                userTransaction.begin();
                try {
                    Assert.assertSame((String)"Extended non-extended entity manager to be same instance as extendend entity manager", (Object)inheritedDelegate, (Object)nonExtendedEm.getDelegate());
                }
                finally {
                    userTransaction.commit();
                }
                PersistenceContextStatefulHome home = (PersistenceContextStatefulHome)this.ejbContext.getEJBHome();
                PersistenceContextStatefulObject object = home.create();
                object.testPropgation();
                object.remove();
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void testPropgation() throws TestFailureException {
        if (inheritedDelegate == null) {
            return;
        }
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                EntityManager em = (EntityManager)ctx.lookup("java:comp/env/persistence/ExtendedTestContext");
                Assert.assertNotNull((String)"The EntityManager is null", (Object)em);
                em.getFlushMode();
                EntityManager delegate = (EntityManager)em.getDelegate();
                Assert.assertSame((String)"Extended entity manager delegate should be the same instance that was found last time", (Object)inheritedDelegate, (Object)delegate);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }
}

