/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import java.lang.reflect.Method;
import javax.jms.Connection;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;

public class MdbUtil {
    public static String getSignature(Method method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getName()).append("(");
        boolean first = true;
        for (Class<?> type : method.getParameterTypes()) {
            if (!first) {
                builder.append(",");
            }
            builder.append(type.getName());
            first = false;
        }
        builder.append(")");
        return builder.toString();
    }

    public static void close(MessageProducer closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(MessageConsumer closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(Session closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(Connection closeable) {
        if (closeable != null) {
            try {
                closeable.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

