/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.beans;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ejb.Stateless;
import org.apache.openejb.test.beans.TimerSync;

@Stateless
public class TimerSyncBean
implements TimerSync {
    private static Map<String, CountDownLatch> latches = new TreeMap<String, CountDownLatch>();

    @Override
    public boolean waitFor(String name) {
        CountDownLatch latch = this.getLatch(name);
        try {
            return latch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void countDown(String name) {
        CountDownLatch latch = this.getLatch(name);
        latch.countDown();
    }

    private synchronized CountDownLatch getLatch(String name) {
        CountDownLatch latch = latches.get(name);
        if (latch == null) {
            latch = new CountDownLatch(1);
            latches.put(name, latch);
        }
        return latch;
    }
}

