/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.descriptor.web.WebXmlParser;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.JarFactory;
import org.xml.sax.InputSource;

public class FragmentJarScannerCallback
implements JarScannerCallback {
    private static final String FRAGMENT_LOCATION = "META-INF/web-fragment.xml";
    private final WebXmlParser webXmlParser;
    private final boolean delegate;
    private final boolean parseRequired;
    private final Map<String, WebXml> fragments = new HashMap<String, WebXml>();
    private boolean ok = true;

    public FragmentJarScannerCallback(WebXmlParser webXmlParser, boolean delegate, boolean parseRequired) {
        this.webXmlParser = webXmlParser;
        this.delegate = delegate;
        this.parseRequired = parseRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(JarURLConnection jarConn, String webappPath, boolean isWebapp) throws IOException {
        URL url = jarConn.getURL();
        URL resourceURL = jarConn.getJarFileURL();
        Jar jar = null;
        InputStream is = null;
        WebXml fragment = new WebXml();
        fragment.setWebappJar(isWebapp);
        fragment.setDelegate(this.delegate);
        try {
            if (isWebapp && this.parseRequired) {
                jar = JarFactory.newInstance(url);
                is = jar.getInputStream(FRAGMENT_LOCATION);
            }
            if (is == null) {
                fragment.setDistributable(true);
            } else {
                InputSource source = new InputSource("jar:" + resourceURL.toString() + "!/" + FRAGMENT_LOCATION);
                source.setByteStream(is);
                if (!this.webXmlParser.parseWebXml(source, fragment, true)) {
                    this.ok = false;
                }
            }
        }
        finally {
            if (jar != null) {
                jar.close();
            }
            fragment.setURL(url);
            if (fragment.getName() == null) {
                fragment.setName(fragment.getURL().toString());
            }
            fragment.setJarName(this.extractJarFileName(url));
            this.fragments.put(fragment.getName(), fragment);
        }
    }

    private String extractJarFileName(URL input) {
        String url = input.toString();
        if (url.endsWith("!/")) {
            url = url.substring(0, url.length() - 2);
        }
        return url.substring(url.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(File file, String webappPath, boolean isWebapp) throws IOException {
        FileInputStream stream = null;
        WebXml fragment = new WebXml();
        fragment.setWebappJar(isWebapp);
        fragment.setDelegate(this.delegate);
        try {
            File fragmentFile = new File(file, FRAGMENT_LOCATION);
            if (fragmentFile.isFile()) {
                stream = new FileInputStream(fragmentFile);
                InputSource source = new InputSource(fragmentFile.toURI().toURL().toString());
                source.setByteStream(stream);
                if (!this.webXmlParser.parseWebXml(source, fragment, true)) {
                    this.ok = false;
                }
            } else {
                fragment.setDistributable(true);
            }
        }
        finally {
            fragment.setURL(file.toURI().toURL());
            if (fragment.getName() == null) {
                fragment.setName(fragment.getURL().toString());
            }
            fragment.setJarName(file.getName());
            this.fragments.put(fragment.getName(), fragment);
        }
    }

    public void scanWebInfClasses() {
    }

    public boolean isOk() {
        return this.ok;
    }

    public Map<String, WebXml> getFragments() {
        return this.fragments;
    }
}

