/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class OneLineFormatter
extends Formatter {
    private static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ST_SEP = LINE_SEP + " ";
    private final SimpleDateFormat dayFormatter = new SimpleDateFormat("dd");
    private final SimpleDateFormat monthFormatter = new SimpleDateFormat("MM");
    private final SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
    private final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss.S");
    private Date currentDate;
    private String currentDateString;

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        this.addTimestamp(sb, new Date(record.getMillis()));
        sb.append(' ');
        sb.append(record.getLevel());
        sb.append(' ');
        sb.append(record.getSourceClassName());
        sb.append('.');
        sb.append(record.getSourceMethodName());
        sb.append(' ');
        sb.append(record.getMessage());
        if (record.getThrown() != null) {
            sb.append(ST_SEP);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.getBuffer());
        }
        sb.append(LINE_SEP);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimestamp(StringBuilder buf, Date date) {
        if (this.currentDate != date) {
            OneLineFormatter oneLineFormatter = this;
            synchronized (oneLineFormatter) {
                if (this.currentDate != date) {
                    StringBuilder current = new StringBuilder(32);
                    current.append(this.dayFormatter.format(date));
                    current.append('-');
                    current.append(this.lookup(this.monthFormatter.format(date)));
                    current.append('-');
                    current.append(this.yearFormatter.format(date));
                    current.append(' ');
                    current.append(this.timeFormatter.format(date));
                    this.currentDateString = current.toString();
                    this.currentDate = date;
                }
            }
        }
        buf.append(this.currentDateString);
    }

    private String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable t) {
            index = 0;
        }
        return months[index];
    }
}

