/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.common.run;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;

public final class EmbeddedRegistry {
    private static EmbeddedRegistry instance;
    private Set<Object> containers = new HashSet<Object>(1);

    private EmbeddedRegistry() {
    }

    public static EmbeddedRegistry getInstance() {
        if (instance == null) {
            instance = new EmbeddedRegistry();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        EmbeddedRegistry.getInstance().shutdownAll(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return instance;
    }

    public synchronized boolean register(Object container) {
        return this.containers.add(container);
    }

    public synchronized void shutdownAll(Log log) throws Exception {
        ReflectiveOperationException firstException = null;
        Iterator<Object> iterator = this.containers.iterator();
        while (iterator.hasNext()) {
            Object embedded = iterator.next();
            try {
                Method method = embedded.getClass().getMethod("stop", null);
                method.invoke(embedded, null);
                iterator.remove();
            }
            catch (NoSuchMethodException e) {
                if (firstException == null) {
                    firstException = e;
                    this.error(log, e, "no stop method in class " + embedded.getClass().getName());
                    continue;
                }
                this.error(log, e, "Error while shutting down embedded Tomcat.");
            }
            catch (IllegalAccessException e) {
                if (firstException == null) {
                    firstException = e;
                    this.error(log, e, "IllegalAccessException for stop method in class " + embedded.getClass().getName());
                    continue;
                }
                this.error(log, e, "Error while shutting down embedded Tomcat.");
            }
            catch (InvocationTargetException e) {
                if (firstException == null) {
                    firstException = e;
                    this.error(log, e, "IllegalAccessException for stop method in class " + embedded.getClass().getName());
                    continue;
                }
                this.error(log, e, "Error while shutting down embedded Tomcat.");
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    private void error(Log log, Exception e, String message) {
        if (log == null) {
            System.err.println("ERROR: " + message);
            e.printStackTrace();
        } else {
            log.error((CharSequence)message, (Throwable)e);
        }
    }
}

