/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.common.run;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tomcat.maven.common.run.ClassLoaderEntriesCalculator;
import org.apache.tomcat.maven.common.run.ClassLoaderEntriesCalculatorRequest;
import org.apache.tomcat.maven.common.run.ClassLoaderEntriesCalculatorResult;
import org.apache.tomcat.maven.common.run.TomcatRunException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ClassLoaderEntriesCalculator.class)
public class DefaultClassLoaderEntriesCalculator
implements ClassLoaderEntriesCalculator {
    @Requirement
    private ArchiverManager archiverManager;

    public ClassLoaderEntriesCalculatorResult calculateClassPathEntries(ClassLoaderEntriesCalculatorRequest request) throws TomcatRunException {
        LinkedHashSet<String> classLoaderEntries = new LinkedHashSet<String>();
        ArrayList<String> fileInClassLoaderEntries = new ArrayList<String>();
        ArrayList<File> tmpDirectories = new ArrayList<File>();
        try {
            List classPathElements;
            List list = classPathElements = request.isUseTestClassPath() ? request.getMavenProject().getTestClasspathElements() : request.getMavenProject().getRuntimeClasspathElements();
            if (classPathElements != null) {
                for (String classPathElement : classPathElements) {
                    File classPathElementFile = new File(classPathElement);
                    if (!classPathElementFile.isDirectory()) continue;
                    request.getLog().debug((CharSequence)("adding classPathElementFile " + classPathElementFile.toURI().toString()));
                    classLoaderEntries.add(classPathElementFile.toURI().toString());
                }
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new TomcatRunException(e.getMessage(), e);
        }
        File tmpExtractDatas = new File(request.getMavenProject().getBuild().getDirectory(), "apache-tomcat-maven-plugin");
        tmpExtractDatas.mkdirs();
        if (request.getDependencies() != null) {
            for (Artifact artifact : request.getDependencies()) {
                boolean existed;
                String scope = artifact.getScope();
                if (!("provided".equals(scope) || "test".equals(scope) && !request.isUseTestClassPath())) {
                    request.getLog().debug((CharSequence)("add dependency to webapploader " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getScope()));
                    if (!this.isInProjectReferences(artifact, request.getMavenProject()) || artifact.getFile().isFile()) {
                        String fileName = artifact.getGroupId() + "-" + artifact.getFile().getName();
                        if (!fileInClassLoaderEntries.contains(fileName)) {
                            classLoaderEntries.add(artifact.getFile().toURI().toString());
                            fileInClassLoaderEntries.add(fileName);
                        }
                    } else {
                        request.getLog().debug((CharSequence)("skip adding artifact " + artifact.getArtifactId() + " as it's in reactors"));
                    }
                }
                if (!"war".equals(artifact.getType()) || !request.isAddWarDependenciesInClassloader()) continue;
                File tmpDir = new File(tmpExtractDatas, artifact.getArtifactId());
                boolean bl = existed = !tmpDir.mkdirs();
                if (existed) {
                    long dirLastMod = tmpDir.lastModified();
                    long warLastMod = artifact.getFile().lastModified();
                    if (warLastMod == 0L || warLastMod > dirLastMod) {
                        request.getLog().debug((CharSequence)("re-exploding artifact " + artifact.getArtifactId() + " due to newer WAR"));
                        this.deleteDirectory(tmpDir, request.getLog());
                        tmpDir = new File(tmpExtractDatas, artifact.getArtifactId());
                        tmpDir.mkdirs();
                        existed = false;
                    } else {
                        request.getLog().debug((CharSequence)("using existing exploded war for artifact " + artifact.getArtifactId()));
                    }
                }
                tmpDirectories.add(tmpDir);
                try {
                    File classesDirectory;
                    File libsDirectory;
                    if (!existed) {
                        File warFile = artifact.getFile();
                        UnArchiver unArchiver = this.archiverManager.getUnArchiver("jar");
                        unArchiver.setSourceFile(warFile);
                        unArchiver.setDestDirectory(tmpDir);
                        unArchiver.extract();
                    }
                    if ((libsDirectory = new File(tmpDir, "WEB-INF/lib")).exists()) {
                        String[] jars;
                        for (String jar : jars = libsDirectory.list(new FilenameFilter(){

                            public boolean accept(File file, String s) {
                                return s.endsWith(".jar");
                            }
                        })) {
                            File jarFile = new File(libsDirectory, jar);
                            if (!fileInClassLoaderEntries.contains(jarFile.getName())) {
                                classLoaderEntries.add(jarFile.toURI().toString());
                                fileInClassLoaderEntries.add(jarFile.getName());
                                continue;
                            }
                            request.getLog().debug((CharSequence)("skip adding file " + jarFile.getPath() + " as it's already in classloader entries"));
                        }
                    }
                    if (!(classesDirectory = new File(tmpDir, "WEB-INF/classes")).exists()) continue;
                    classLoaderEntries.add(classesDirectory.toURI().toString());
                }
                catch (NoSuchArchiverException e) {
                    throw new TomcatRunException(e.getMessage(), e);
                }
                catch (ArchiverException e) {
                    request.getLog().error((CharSequence)("fail to extract war file " + artifact.getFile() + ", reason:" + e.getMessage()), (Throwable)e);
                    throw new TomcatRunException(e.getMessage(), e);
                }
            }
        }
        return new ClassLoaderEntriesCalculatorResult(new ArrayList<String>(classLoaderEntries), tmpDirectories);
    }

    private void deleteDirectory(File directory, Log log) throws TomcatRunException {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            log.error((CharSequence)("fail to delete directory file " + directory + ", reason:" + e.getMessage()), (Throwable)e);
            throw new TomcatRunException(e.getMessage(), e);
        }
    }

    protected boolean isInProjectReferences(Artifact artifact, MavenProject project) {
        if (project.getProjectReferences() == null || project.getProjectReferences().isEmpty()) {
            return false;
        }
        Collection mavenProjects = project.getProjectReferences().values();
        for (MavenProject mavenProject : mavenProjects) {
            if (!StringUtils.equals((String)mavenProject.getId(), (String)artifact.getId())) continue;
            return true;
        }
        return false;
    }
}

