/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspEngineInfo;
import jakarta.servlet.jsp.JspFactory;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.jasper.Constants;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.PageContextImpl;

public class JspFactoryImpl
extends JspFactory {
    private final ThreadLocal<PageContextPool> localPool = new ThreadLocal();
    private int poolSize = -1;

    @Override
    public PageContext getPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedGetPageContext dp = new PrivilegedGetPageContext(this, servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
            return AccessController.doPrivileged(dp);
        }
        return this.internalGetPageContext(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
    }

    @Override
    public void releasePageContext(PageContext pc) {
        if (pc == null) {
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedReleasePageContext dp = new PrivilegedReleasePageContext(this, pc);
            AccessController.doPrivileged(dp);
        } else {
            this.internalReleasePageContext(pc);
        }
    }

    @Override
    public JspEngineInfo getEngineInfo() {
        return new JspEngineInfo(){

            @Override
            public String getSpecificationVersion() {
                return "3.1";
            }
        };
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    private PageContext internalGetPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        PageContext pc;
        if (this.poolSize > 0) {
            PageContextPool pool = this.localPool.get();
            if (pool == null) {
                pool = new PageContextPool(this.poolSize);
                this.localPool.set(pool);
            }
            if ((pc = pool.get()) == null) {
                pc = new PageContextImpl();
            }
        } else {
            pc = new PageContextImpl();
        }
        try {
            ((PageContext)pc).initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pc;
    }

    private void internalReleasePageContext(PageContext pc) {
        pc.release();
        if (this.poolSize > 0 && pc instanceof PageContextImpl) {
            this.localPool.get().put(pc);
        }
    }

    @Override
    public JspApplicationContext getJspApplicationContext(ServletContext context) {
        if (Constants.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(() -> JspApplicationContextImpl.getInstance(context));
        }
        return JspApplicationContextImpl.getInstance(context);
    }

    private static final class PageContextPool {
        private final PageContext[] pool;
        private int current = -1;

        public PageContextPool(int poolSize) {
            this.pool = new PageContext[poolSize];
        }

        public void put(PageContext o) {
            if (this.current < this.pool.length - 1) {
                ++this.current;
                this.pool[this.current] = o;
            }
        }

        public PageContext get() {
            PageContext item = null;
            if (this.current >= 0) {
                item = this.pool[this.current];
                --this.current;
            }
            return item;
        }
    }

    private static class PrivilegedReleasePageContext
    implements PrivilegedAction<Void> {
        private JspFactoryImpl factory;
        private PageContext pageContext;

        PrivilegedReleasePageContext(JspFactoryImpl factory, PageContext pageContext) {
            this.factory = factory;
            this.pageContext = pageContext;
        }

        @Override
        public Void run() {
            this.factory.internalReleasePageContext(this.pageContext);
            return null;
        }
    }

    private static class PrivilegedGetPageContext
    implements PrivilegedAction<PageContext> {
        private JspFactoryImpl factory;
        private Servlet servlet;
        private ServletRequest request;
        private ServletResponse response;
        private String errorPageURL;
        private boolean needsSession;
        private int bufferSize;
        private boolean autoflush;

        PrivilegedGetPageContext(JspFactoryImpl factory, Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
            this.factory = factory;
            this.servlet = servlet;
            this.request = request;
            this.response = response;
            this.errorPageURL = errorPageURL;
            this.needsSession = needsSession;
            this.bufferSize = bufferSize;
            this.autoflush = autoflush;
        }

        @Override
        public PageContext run() {
            return this.factory.internalGetPageContext(this.servlet, this.request, this.response, this.errorPageURL, this.needsSession, this.bufferSize, this.autoflush);
        }
    }
}

