/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Attribute
implements Serializable {
    protected String role = null;
    protected Object value = null;
    private AttributeType type = null;
    private String name = null;

    public Attribute() {
    }

    public Attribute(Object value) {
        this.value = value;
    }

    public Attribute(Attribute attribute) {
        this.name = attribute.name;
        this.role = attribute.role;
        this.type = attribute.type;
        this.value = attribute.getValue();
    }

    public Attribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public Attribute(Object value, String role) {
        this.value = value;
        this.role = role;
    }

    public Attribute(Object value, String role, AttributeType type) {
        this.value = value;
        this.role = role;
        this.type = type;
    }

    public Attribute(String name, Object value, String role, AttributeType type) {
        this.name = name;
        this.value = value;
        this.role = role;
        this.type = type;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public AttributeType getType() {
        return this.type;
    }

    public void setType(AttributeType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBody(String body) {
        if (body != null && body.length() != 0) {
            this.setValue(body);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeType {
        STRING("string"),
        DEFINITION("definition"),
        TEMPLATE("template"),
        OBJECT("object");

        private String stringRepresentation;
        private static Map<String, AttributeType> representation2type;

        public static AttributeType getType(String stringRepresentation) {
            return representation2type.get(stringRepresentation);
        }

        private AttributeType(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        static {
            representation2type = new HashMap<String, AttributeType>();
            representation2type.put("string", STRING);
            representation2type.put("definition", DEFINITION);
            representation2type.put("template", TEMPLATE);
            representation2type.put("object", OBJECT);
        }
    }
}

