/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.ComponentContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.web.ComponentContextMutator;

public class TilesDispatchServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(TilesDispatchServlet.class);
    private ComponentContextMutator mutator;

    public void init() throws ServletException {
        super.init();
        String temp = this.getInitParameter("mutator");
        if (temp != null) {
            try {
                this.mutator = (ComponentContextMutator)Class.forName(temp).newInstance();
            }
            catch (Exception e) {
                throw new ServletException("Unable to instantiate specified context mutator.", (Throwable)e);
            }
        } else {
            this.mutator = new DefaultMutator();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        TilesContainer container = TilesAccess.getContainer(this.getServletContext());
        this.mutator.mutate(container.getComponentContext(req, res), (ServletRequest)req);
        try {
            String definition = this.getDefinitionName(req);
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Dispatching to tile '" + definition + "'"));
            }
            container.render(req, res, definition);
        }
        catch (TilesException e) {
            throw new ServletException("Error rendering tile.", (Throwable)e);
        }
    }

    protected String getDefinitionName(HttpServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (path == null) {
            path = request.getServletPath();
        }
        int start = path.startsWith("/") ? 1 : 0;
        int end = path.endsWith(".tiles") ? path.indexOf(".tiles") : path.length();
        return path.substring(start, end);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        LOG.info((Object)"Tiles dispatch request received. Redirecting POST to GET.");
        this.doGet(req, res);
    }

    class DefaultMutator
    implements ComponentContextMutator {
        DefaultMutator() {
        }

        public void mutate(ComponentContext context, ServletRequest request) {
        }
    }
}

