/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.nio.charset.Charset;
import org.apache.tika.detect.TextStatistics;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.utils.CharsetUtils;
import org.mozilla.universalchardet.CharsetListener;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.UniversalDetector;

class UniversalEncodingListener
implements CharsetListener {
    private static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    private static final String CHARSET_ISO_8859_15 = "ISO-8859-15";
    private final TextStatistics statistics = new TextStatistics();
    private final UniversalDetector detector = new UniversalDetector((CharsetListener)this);
    private String hint = null;
    private Charset charset = null;

    public UniversalEncodingListener(Metadata metadata) {
        MediaType type = MediaType.parse((String)metadata.get("Content-Type"));
        if (type != null) {
            this.hint = (String)type.getParameters().get("charset");
        }
        if (this.hint == null) {
            this.hint = metadata.get("Content-Encoding");
        }
    }

    public void report(String name) {
        if (Constants.CHARSET_WINDOWS_1252.equals(name)) {
            if (this.hint != null) {
                name = this.hint;
            } else if (this.statistics.count(13) == 0) {
                name = this.statistics.count(164) > 0 ? CHARSET_ISO_8859_15 : CHARSET_ISO_8859_1;
            }
        }
        try {
            this.charset = CharsetUtils.forName((String)name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public boolean isDone() {
        return this.detector.isDone();
    }

    public void handleData(byte[] buf, int offset, int length) {
        this.statistics.addData(buf, offset, length);
        this.detector.handleData(buf, offset, length);
    }

    public Charset dataEnd() {
        this.detector.dataEnd();
        if (this.charset == null && this.statistics.isMostlyAscii()) {
            this.report(Constants.CHARSET_WINDOWS_1252);
        }
        return this.charset;
    }
}

