/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.mp4.Mp4BoxHandler;
import com.drew.metadata.mp4.Mp4Context;
import java.io.IOException;
import org.apache.tika.parser.mp4.boxes.TikaUserDataBox;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class TikaMp4BoxHandler
extends Mp4BoxHandler {
    org.apache.tika.metadata.Metadata tikaMetadata;
    final XHTMLContentHandler xhtml;

    public TikaMp4BoxHandler(Metadata metadata, org.apache.tika.metadata.Metadata tikaMetadata, XHTMLContentHandler xhtml) {
        super(metadata);
        this.tikaMetadata = tikaMetadata;
        this.xhtml = xhtml;
    }

    public boolean shouldAcceptBox(@NotNull String type) {
        if (type.equals("udta")) {
            return true;
        }
        return super.shouldAcceptBox(type);
    }

    public boolean shouldAcceptContainer(@NotNull String type) {
        return super.shouldAcceptContainer(type);
    }

    public Mp4Handler<?> processBox(@NotNull String type, @Nullable byte[] payload, long boxSize, Mp4Context context) throws IOException {
        if (type.equals("udta")) {
            return this.processUserData(type, payload, boxSize);
        }
        return super.processBox(type, payload, boxSize, context);
    }

    private Mp4Handler<?> processUserData(String type, byte[] payload, long length) throws IOException {
        if (payload == null) {
            return this;
        }
        try {
            new TikaUserDataBox(type, payload, this.tikaMetadata, this.xhtml).addMetadata(this.directory);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return this;
    }
}

