/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dbf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.dbf.DBFCell;
import org.apache.tika.parser.dbf.DBFColumnHeader;
import org.apache.tika.parser.dbf.DBFFileHeader;
import org.apache.tika.parser.dbf.DBFReader;
import org.apache.tika.parser.dbf.DBFRow;
import org.apache.tika.parser.txt.Icu4jEncodingDetector;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DBFParser
extends AbstractParser {
    private static final int ROWS_TO_BUFFER_FOR_CHARSET_DETECTION = 10;
    private static final int MAX_CHARS_FOR_CHARSET_DETECTION = 20000;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-dbf"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        DBFReader reader = DBFReader.open(stream);
        DBFFileHeader header = reader.getHeader();
        metadata.set("Content-Type", header.getVersion().getFullMimeString());
        Calendar lastModified = header.getLastModified();
        if (lastModified != null) {
            metadata.set(TikaCoreProperties.MODIFIED, lastModified);
        }
        LinkedList<DBFRow> firstRows = new LinkedList<DBFRow>();
        DBFRow row = reader.next();
        int i = 0;
        while (row != null && i++ < 10) {
            firstRows.add(row.deepCopy());
            row = reader.next();
        }
        Charset charset = this.getCharset(firstRows, header);
        metadata.set("Content-Encoding", charset.toString());
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.startElement("table");
        xhtml.startElement("thead");
        for (DBFColumnHeader col : header.getCols()) {
            xhtml.startElement("th");
            xhtml.characters(col.getName(charset));
            xhtml.endElement("th");
        }
        xhtml.endElement("thead");
        xhtml.startElement("tbody");
        while (firstRows.size() > 0) {
            DBFRow cachedRow = (DBFRow)firstRows.remove(0);
            this.writeRow(cachedRow, charset, xhtml);
        }
        while (row != null) {
            this.writeRow(row, charset, xhtml);
            row = reader.next();
        }
        xhtml.endElement("tbody");
        xhtml.endElement("table");
        xhtml.endDocument();
    }

    private Charset getCharset(List<DBFRow> firstRows, DBFFileHeader header) throws IOException, TikaException {
        Charset charset = DEFAULT_CHARSET;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        block0: for (DBFRow row : firstRows) {
            for (DBFCell cell : row.cells) {
                if (!cell.getColType().equals((Object)DBFColumnHeader.ColType.C)) continue;
                byte[] bytes = cell.getBytes();
                bos.write(bytes);
                if (bos.size() > 20000) continue block0;
            }
        }
        byte[] bytes = bos.toByteArray();
        if (bytes.length > 20) {
            Icu4jEncodingDetector detector = new Icu4jEncodingDetector();
            detector.detect((InputStream)TikaInputStream.get((byte[])bytes), new Metadata());
            charset = detector.detect(new ByteArrayInputStream(bytes), new Metadata());
        }
        return charset;
    }

    private void writeRow(DBFRow row, Charset charset, XHTMLContentHandler xhtml) throws SAXException {
        xhtml.startElement("tr");
        for (DBFCell cell : row.cells) {
            xhtml.startElement("td");
            xhtml.characters(cell.getString(charset));
            xhtml.endElement("td");
        }
        xhtml.endElement("tr");
    }
}

