/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.riff.RiffProcessingException;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.webp.WebpMetadataReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.GeoLocation;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.jpeg.JpegCommentDirectory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.poi.util.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.IPTC;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.image.MetadataFields;
import org.apache.tika.parser.image.xmp.JempboxExtractor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ImageMetadataExtractor {
    private static final String GEO_DECIMAL_FORMAT_STRING = "#.######";
    private final org.apache.tika.metadata.Metadata metadata;
    private DirectoryHandler[] handlers;

    public ImageMetadataExtractor(org.apache.tika.metadata.Metadata metadata) {
        this(metadata, new CopyUnknownFieldsHandler(), new JpegCommentHandler(), new ExifHandler(), new DimensionsHandler(), new GeotagHandler(), new IptcHandler());
    }

    public ImageMetadataExtractor(org.apache.tika.metadata.Metadata metadata, DirectoryHandler ... handlers) {
        this.metadata = metadata;
        this.handlers = handlers;
    }

    private static String trimPixels(String s) {
        if (s != null) {
            int i = s.lastIndexOf(" pixels");
            s = s.substring(0, i);
        }
        return s;
    }

    public void parseJpeg(File file) throws IOException, SAXException, TikaException {
        try {
            Metadata jpegMetadata = JpegMetadataReader.readMetadata((File)file);
            this.handle(jpegMetadata);
        }
        catch (JpegProcessingException e) {
            throw new TikaException("Can't read JPEG metadata", (Throwable)e);
        }
        catch (MetadataException e) {
            throw new TikaException("Can't read JPEG metadata", (Throwable)e);
        }
    }

    public void parseTiff(File file) throws IOException, SAXException, TikaException {
        try {
            Metadata tiffMetadata = TiffMetadataReader.readMetadata((File)file);
            this.handle(tiffMetadata);
        }
        catch (MetadataException e) {
            throw new TikaException("Can't read TIFF metadata", (Throwable)e);
        }
        catch (TiffProcessingException e) {
            throw new TikaException("Can't read TIFF metadata", (Throwable)e);
        }
    }

    public void parseWebP(File file) throws IOException, TikaException {
        try {
            Metadata webPMetadata = new Metadata();
            webPMetadata = WebpMetadataReader.readMetadata((File)file);
            this.handle(webPMetadata);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RiffProcessingException e) {
            throw new TikaException("Can't process Riff data", (Throwable)e);
        }
        catch (MetadataException e) {
            throw new TikaException("Can't process Riff data", (Throwable)e);
        }
    }

    public void parseRawExif(InputStream stream, int length, boolean needsExifHeader) throws IOException, SAXException, TikaException {
        byte[] exif;
        if (needsExifHeader) {
            exif = new byte[length + 6];
            exif[0] = 69;
            exif[1] = 120;
            exif[2] = 105;
            exif[3] = 102;
            IOUtils.readFully((InputStream)stream, (byte[])exif, (int)6, (int)length);
        } else {
            exif = new byte[length];
            IOUtils.readFully((InputStream)stream, (byte[])exif, (int)0, (int)length);
        }
        this.parseRawExif(exif);
    }

    public void parseRawExif(byte[] exifData) throws IOException, SAXException, TikaException {
        Metadata metadata = new Metadata();
        ExifReader reader = new ExifReader();
        reader.extract((RandomAccessReader)new ByteArrayReader(exifData), metadata, "Exif\u0000\u0000".length());
        try {
            this.handle(metadata);
        }
        catch (MetadataException e) {
            throw new TikaException("Can't process the EXIF Data", (Throwable)e);
        }
    }

    public void parseRawXMP(byte[] xmpData) throws IOException, SAXException, TikaException {
        XMPMetadata xmp = null;
        try (ByteArrayInputStream decoded = new ByteArrayInputStream(xmpData);){
            Document dom = new ParseContext().getDocumentBuilder().parse(decoded);
            if (dom != null) {
                xmp = new XMPMetadata(dom);
            }
        }
        catch (IOException | SAXException exception) {
            // empty catch block
        }
        if (xmp != null) {
            JempboxExtractor.extractDublinCore(xmp, this.metadata);
            JempboxExtractor.extractXMPMM(xmp, this.metadata);
        }
    }

    protected void handle(Metadata metadataExtractor) throws MetadataException {
        this.handle(metadataExtractor.getDirectories().iterator());
    }

    protected void handle(Iterator<Directory> directories) throws MetadataException {
        while (directories.hasNext()) {
            Directory directory = directories.next();
            for (DirectoryHandler handler : this.handlers) {
                if (!handler.supports(directory.getClass())) continue;
                handler.handle(directory, this.metadata);
            }
        }
    }

    static class GeotagHandler
    implements DirectoryHandler {
        GeotagHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == GpsDirectory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            GeoLocation geoLocation = ((GpsDirectory)directory).getGeoLocation();
            if (geoLocation != null) {
                DecimalFormat geoDecimalFormat = new DecimalFormat(ImageMetadataExtractor.GEO_DECIMAL_FORMAT_STRING, new DecimalFormatSymbols(Locale.ENGLISH));
                metadata.set(TikaCoreProperties.LATITUDE, geoDecimalFormat.format(geoLocation.getLatitude()));
                metadata.set(TikaCoreProperties.LONGITUDE, geoDecimalFormat.format(geoLocation.getLongitude()));
            }
        }
    }

    static class IptcHandler
    implements DirectoryHandler {
        IptcHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == IptcDirectory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            if (directory.containsTag(537)) {
                String[] keywords;
                for (String k : keywords = directory.getStringArray(537)) {
                    metadata.add(TikaCoreProperties.KEYWORDS, k);
                }
            }
            if (directory.containsTag(617)) {
                metadata.set(TikaCoreProperties.TITLE, directory.getString(617));
            } else if (directory.containsTag(517)) {
                metadata.set(TikaCoreProperties.TITLE, directory.getString(517));
            }
            if (directory.containsTag(592)) {
                metadata.set(TikaCoreProperties.CREATOR, directory.getString(592));
                metadata.set(IPTC.CREATOR, directory.getString(592));
            }
            if (directory.containsTag(632)) {
                metadata.set(TikaCoreProperties.DESCRIPTION, directory.getString(632).replaceAll("\r\n?", "\n"));
            }
        }
    }

    static class ExifHandler
    implements DirectoryHandler {
        private static final ThreadLocal<SimpleDateFormat> DATE_UNSPECIFIED_TZ = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
            }
        };

        ExifHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == ExifIFD0Directory.class || directoryType == ExifSubIFDDirectory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) {
            try {
                this.handleDateTags(directory, metadata);
                this.handlePhotoTags(directory, metadata);
                this.handleCommentTags(directory, metadata);
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
        }

        public void handleCommentTags(Directory directory, org.apache.tika.metadata.Metadata metadata) {
            if (metadata.get(TikaCoreProperties.DESCRIPTION) == null && directory.containsTag(270)) {
                metadata.set(TikaCoreProperties.DESCRIPTION, directory.getString(270));
            }
        }

        public void handlePhotoTags(Directory directory, org.apache.tika.metadata.Metadata metadata) {
            Object resolution;
            Object length;
            String flash;
            if (directory.containsTag(33434)) {
                Object exposure = directory.getObject(33434);
                if (exposure instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.EXPOSURE_TIME, ((Rational)exposure).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.EXPOSURE_TIME, directory.getString(33434));
                }
            }
            if (directory.containsTag(37385) && (flash = directory.getDescription(37385)) != null) {
                if (flash.contains("Flash fired")) {
                    metadata.set(org.apache.tika.metadata.Metadata.FLASH_FIRED, Boolean.TRUE.toString());
                } else if (flash.contains("Flash did not fire")) {
                    metadata.set(org.apache.tika.metadata.Metadata.FLASH_FIRED, Boolean.FALSE.toString());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.FLASH_FIRED, flash);
                }
            }
            if (directory.containsTag(33437)) {
                Object fnumber = directory.getObject(33437);
                if (fnumber instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.F_NUMBER, ((Rational)fnumber).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.F_NUMBER, directory.getString(33437));
                }
            }
            if (directory.containsTag(37386)) {
                length = directory.getObject(37386);
                if (length instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.FOCAL_LENGTH, ((Rational)length).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.FOCAL_LENGTH, directory.getString(37386));
                }
            }
            if (directory.containsTag(34855)) {
                metadata.set(org.apache.tika.metadata.Metadata.ISO_SPEED_RATINGS, directory.getString(34855));
            }
            if (directory.containsTag(271)) {
                metadata.set(org.apache.tika.metadata.Metadata.EQUIPMENT_MAKE, directory.getString(271));
            }
            if (directory.containsTag(272)) {
                metadata.set(org.apache.tika.metadata.Metadata.EQUIPMENT_MODEL, directory.getString(272));
            }
            if (directory.containsTag(274)) {
                length = directory.getObject(274);
                if (length instanceof Integer) {
                    metadata.set(org.apache.tika.metadata.Metadata.ORIENTATION, Integer.toString((Integer)length));
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.ORIENTATION, directory.getString(274));
                }
            }
            if (directory.containsTag(305)) {
                metadata.set(org.apache.tika.metadata.Metadata.SOFTWARE, directory.getString(305));
            }
            if (directory.containsTag(282)) {
                resolution = directory.getObject(282);
                if (resolution instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_HORIZONTAL, ((Rational)resolution).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_HORIZONTAL, directory.getString(282));
                }
            }
            if (directory.containsTag(283)) {
                resolution = directory.getObject(283);
                if (resolution instanceof Rational) {
                    metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_VERTICAL, ((Rational)resolution).doubleValue());
                } else {
                    metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_VERTICAL, directory.getString(283));
                }
            }
            if (directory.containsTag(296)) {
                metadata.set(org.apache.tika.metadata.Metadata.RESOLUTION_UNIT, directory.getDescription(296));
            }
            if (directory.containsTag(256)) {
                metadata.set(org.apache.tika.metadata.Metadata.IMAGE_WIDTH, ImageMetadataExtractor.trimPixels(directory.getDescription(256)));
            }
            if (directory.containsTag(257)) {
                metadata.set(org.apache.tika.metadata.Metadata.IMAGE_LENGTH, ImageMetadataExtractor.trimPixels(directory.getDescription(257)));
            }
        }

        public void handleDateTags(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            Date datetime;
            Date original = null;
            if (directory.containsTag(36867) && (original = directory.getDate(36867)) != null) {
                String datetimeNoTimeZone = DATE_UNSPECIFIED_TZ.get().format(original);
                metadata.set(TikaCoreProperties.CREATED, datetimeNoTimeZone);
                metadata.set(org.apache.tika.metadata.Metadata.ORIGINAL_DATE, datetimeNoTimeZone);
            }
            if (directory.containsTag(306) && (datetime = directory.getDate(306)) != null) {
                String datetimeNoTimeZone = DATE_UNSPECIFIED_TZ.get().format(datetime);
                metadata.set(TikaCoreProperties.MODIFIED, datetimeNoTimeZone);
                if (metadata.get(TikaCoreProperties.CREATED) == null) {
                    metadata.set(TikaCoreProperties.CREATED, datetimeNoTimeZone);
                }
            }
        }
    }

    static class JpegCommentHandler
    implements DirectoryHandler {
        JpegCommentHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == JpegCommentDirectory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            if (directory.containsTag(0)) {
                metadata.add(TikaCoreProperties.COMMENTS, directory.getString(0));
            }
        }
    }

    static class DimensionsHandler
    implements DirectoryHandler {
        private final Pattern LEADING_NUMBERS = Pattern.compile("(\\d+)\\s*.*");

        DimensionsHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return directoryType == JpegDirectory.class || directoryType == ExifSubIFDDirectory.class || directoryType == ExifThumbnailDirectory.class || directoryType == ExifIFD0Directory.class;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            this.set(directory, metadata, 3, org.apache.tika.metadata.Metadata.IMAGE_WIDTH);
            this.set(directory, metadata, 1, org.apache.tika.metadata.Metadata.IMAGE_LENGTH);
            this.set(directory, metadata, 0, org.apache.tika.metadata.Metadata.BITS_PER_SAMPLE);
            this.set(directory, metadata, 258, org.apache.tika.metadata.Metadata.BITS_PER_SAMPLE);
            this.set(directory, metadata, 277, org.apache.tika.metadata.Metadata.SAMPLES_PER_PIXEL);
        }

        private void set(Directory directory, org.apache.tika.metadata.Metadata metadata, int extractTag, Property metadataField) {
            Matcher m;
            if (directory.containsTag(extractTag) && (m = this.LEADING_NUMBERS.matcher(directory.getString(extractTag))).matches()) {
                metadata.set(metadataField, m.group(1));
            }
        }
    }

    static class CopyUnknownFieldsHandler
    implements DirectoryHandler {
        CopyUnknownFieldsHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return true;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            if (directory.getTags() != null) {
                for (Tag tag : directory.getTags()) {
                    String name = tag.getTagName();
                    if (MetadataFields.isMetadataField(name) || tag.getDescription() == null) continue;
                    String value = tag.getDescription().trim();
                    if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
                        value = Boolean.TRUE.toString();
                    } else if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                        value = Boolean.FALSE.toString();
                    }
                    metadata.set(name, value);
                }
            }
        }
    }

    static class CopyAllFieldsHandler
    implements DirectoryHandler {
        CopyAllFieldsHandler() {
        }

        @Override
        public boolean supports(Class<? extends Directory> directoryType) {
            return true;
        }

        @Override
        public void handle(Directory directory, org.apache.tika.metadata.Metadata metadata) throws MetadataException {
            if (directory.getTags() != null) {
                for (Tag tag : directory.getTags()) {
                    metadata.set(tag.getTagName(), tag.getDescription());
                }
            }
        }
    }

    static interface DirectoryHandler {
        public boolean supports(Class<? extends Directory> var1);

        public void handle(Directory var1, org.apache.tika.metadata.Metadata var2) throws MetadataException;
    }
}

