/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.ole;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.config.Field;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class MiscOLEDetector
implements Detector {
    public static final MediaType OLE = MediaType.application((String)"x-tika-msoffice");
    public static final MediaType HWP = MediaType.application((String)"x-hwp-v5");
    public static final MediaType QUATTROPRO = MediaType.application((String)"x-quattro-pro");
    @Field
    private int markLimit = 0x1000000;

    protected static MediaType detect(Set<String> names) {
        return MiscOLEDetector.detect(names, null);
    }

    protected static MediaType detect(Set<String> names, DirectoryEntry root) {
        if (names == null || names.size() == 0) {
            return OLE;
        }
        if (names.contains("\u0005HwpSummaryInformation")) {
            return HWP;
        }
        if (names.contains("PerfectOffice_MAIN")) {
            if (names.contains("SlideShow")) {
                return MediaType.application((String)"x-corelpresentations");
            }
            if (names.contains("PerfectOffice_OBJECTS")) {
                return new MediaType(QUATTROPRO, "version", "7-8");
            }
        } else if (names.contains("NativeContent_MAIN")) {
            return new MediaType(QUATTROPRO, "version", "9");
        }
        return OLE;
    }

    private static Set<String> getTopLevelNames(DirectoryNode root) {
        HashSet<String> names = new HashSet<String>();
        for (Entry entry : root) {
            names.add(entry.getName());
        }
        return names;
    }

    public void setMarkLimit(int markLimit) {
        this.markLimit = markLimit;
    }

    private Set<String> getTopLevelNames(TikaInputStream stream) throws IOException {
        Path file = stream.getPath(this.markLimit);
        if (file == null) {
            return Collections.emptySet();
        }
        try {
            POIFSFileSystem fs = new POIFSFileSystem(file.toFile(), true);
            stream.setOpenContainer((Object)fs);
            return MiscOLEDetector.getTopLevelNames(fs.getRoot());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
        catch (RuntimeException e) {
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        Object container;
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        TikaInputStream tis = TikaInputStream.cast((InputStream)input);
        Set<String> names = null;
        if (tis != null) {
            container = tis.getOpenContainer();
            if (container instanceof POIFSFileSystem) {
                names = MiscOLEDetector.getTopLevelNames(((POIFSFileSystem)container).getRoot());
            } else if (container instanceof DirectoryNode) {
                names = MiscOLEDetector.getTopLevelNames((DirectoryNode)container);
            }
        }
        if (names == null) {
            input.mark(8);
            try {
                if (input.read() != 208 || input.read() != 207 || input.read() != 17 || input.read() != 224 || input.read() != 161 || input.read() != 177 || input.read() != 26 || input.read() != 225) {
                    container = MediaType.OCTET_STREAM;
                    return container;
                }
            }
            catch (IOException e) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
            finally {
                input.reset();
            }
        }
        if (names == null && tis != null) {
            names = this.getTopLevelNames(tis);
        }
        if (tis != null && tis.getOpenContainer() != null && tis.getOpenContainer() instanceof POIFSFileSystem) {
            return MiscOLEDetector.detect(names, (DirectoryEntry)((POIFSFileSystem)tis.getOpenContainer()).getRoot());
        }
        return MiscOLEDetector.detect(names, null);
    }
}

