/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html.charsetdetector;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tika.parser.html.charsetdetector.CharsetDetectionResult;
import org.apache.tika.parser.html.charsetdetector.PreScanner;

class MetaProcessor {
    private Set<String> attributeNames = new HashSet<String>();
    private boolean gotPragma = false;
    private Boolean needPragma = null;
    private CharsetDetectionResult detectionResult = CharsetDetectionResult.notFound();

    MetaProcessor() {
    }

    void updateDetectedCharset(CharsetDetectionResult currentDetectionResult) {
        if (this.detectionResult.isFound() && this.needPragma != null && (!this.needPragma.booleanValue() || this.gotPragma)) {
            currentDetectionResult.setCharset(this.detectionResult.getCharset());
        }
    }

    void processAttribute(Map.Entry<String, String> attribute) {
        if (this.attributeNames.contains(attribute.getKey())) {
            return;
        }
        this.attributeNames.add(attribute.getKey());
        switch (attribute.getKey()) {
            case "http-equiv": {
                if (!attribute.getValue().equals("content-type")) break;
                this.gotPragma = true;
                break;
            }
            case "content": {
                String charsetName = PreScanner.getEncodingFromMeta(attribute.getValue());
                if (this.detectionResult.isFound() || charsetName == null) break;
                this.detectionResult.find(charsetName);
                this.needPragma = true;
                break;
            }
            case "charset": {
                this.detectionResult.find(attribute.getValue());
                this.needPragma = false;
                break;
            }
        }
    }
}

