/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.hwmf.record.HwmfFont;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.hwmf.record.HwmfText;
import org.apache.poi.hwmf.usermodel.HwmfPicture;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.util.RecordFormatException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WMFParser
extends AbstractParser {
    private static final MediaType MEDIA_TYPE = MediaType.image((String)"wmf");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            HwmfPicture picture = null;
            try {
                picture = new HwmfPicture(stream);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new TikaException(e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
            }
            Charset charset = LocaleUtil.CHARSET_1252;
            for (HwmfRecord record : picture.getRecords()) {
                HwmfText.WmfExtTextOut textOut;
                if (record.getWmfRecordType().equals((Object)HwmfRecordType.createFontIndirect)) {
                    HwmfFont font = ((HwmfText.WmfCreateFontIndirect)record).getFont();
                    Charset charset2 = charset = font.getCharset() == null || font.getCharset().getCharset() == null ? LocaleUtil.CHARSET_1252 : font.getCharset().getCharset();
                }
                if (record.getWmfRecordType().equals((Object)HwmfRecordType.extTextOut)) {
                    textOut = (HwmfText.WmfExtTextOut)record;
                    xhtml.startElement("p");
                    xhtml.characters(textOut.getText(charset));
                    xhtml.endElement("p");
                    continue;
                }
                if (!record.getWmfRecordType().equals((Object)HwmfRecordType.textOut)) continue;
                textOut = (HwmfText.WmfTextOut)record;
                xhtml.startElement("p");
                xhtml.characters(textOut.getText(charset));
                xhtml.endElement("p");
            }
        }
        catch (RecordFormatException e) {
            throw new TikaException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new TikaException(e.getMessage(), (Throwable)e);
        }
        catch (AssertionError e) {
            throw new TikaException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
        xhtml.endDocument();
    }
}

