/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.PhoneExtractingContentHandler;
import org.xml.sax.ContentHandler;

public class GrabPhoneNumbersExample {
    private static HashSet<String> phoneNumbers = new HashSet();
    private static int failedFiles;
    private static int successfulFiles;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage `java GrabPhoneNumbers [corpus]");
            return;
        }
        File folder = new File(args[0]);
        System.out.println("Searching " + folder.getAbsolutePath() + "...");
        GrabPhoneNumbersExample.processFolder(folder);
        System.out.println(phoneNumbers.toString());
        System.out.println("Parsed " + successfulFiles + "/" + (successfulFiles + failedFiles));
    }

    public static void processFolder(File folder) {
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                GrabPhoneNumbersExample.processFolder(fileEntry);
                continue;
            }
            try {
                GrabPhoneNumbersExample.process(fileEntry);
                ++successfulFiles;
            }
            catch (Exception e) {
                ++failedFiles;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(File file) throws Exception {
        String[] numbers;
        AutoDetectParser parser = new AutoDetectParser();
        Metadata metadata = new Metadata();
        PhoneExtractingContentHandler handler = new PhoneExtractingContentHandler((ContentHandler)new BodyContentHandler(), metadata);
        FileInputStream stream = new FileInputStream(file);
        try {
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        finally {
            ((InputStream)stream).close();
        }
        for (String number : numbers = metadata.getValues("phonenumbers")) {
            phoneNumbers.add(number);
        }
    }

    static {
        successfulFiles = 0;
    }
}

