/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.DefaultTranslator;
import org.apache.tika.language.translate.Translator;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DumpTikaConfigExample {
    public void dump(TikaConfig config, Writer writer, String encoding) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("properties");
        doc.appendChild(rootElement);
        this.addMimeComment(rootElement, doc);
        this.addTranslator(rootElement, doc, config);
        this.addDetectors(rootElement, doc, config);
        this.addParsers(rootElement, doc, config);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("encoding", encoding);
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
    }

    private void addTranslator(Element rootElement, Document doc, TikaConfig config) {
        Translator translator = config.getTranslator();
        if (translator instanceof DefaultTranslator) {
            Comment mimeComment = doc.createComment("for example: <translator class=\"org.apache.tika.language.translate.GoogleTranslator\"/>");
            rootElement.appendChild(mimeComment);
        } else {
            Element translatorElement = doc.createElement("translator");
            translatorElement.setAttribute("class", translator.getClass().getCanonicalName());
            rootElement.appendChild(translatorElement);
        }
    }

    private void addMimeComment(Element rootElement, Document doc) {
        Comment mimeComment = doc.createComment("for example: <mimeTypeRepository resource=\"/org/apache/tika/mime/tika-mimetypes.xml\"/>");
        rootElement.appendChild(mimeComment);
    }

    private void addDetectors(Element rootElement, Document doc, TikaConfig config) throws Exception {
        Detector detector = config.getDetector();
        Element detectorsElement = doc.createElement("detectors");
        if (detector instanceof DefaultDetector) {
            List children = ((DefaultDetector)detector).getDetectors();
            for (Detector d : children) {
                Element detectorElement = doc.createElement("detector");
                detectorElement.setAttribute("class", d.getClass().getCanonicalName());
                detectorsElement.appendChild(detectorElement);
            }
        }
        rootElement.appendChild(detectorsElement);
    }

    private void addParsers(Element rootElement, Document doc, TikaConfig config) throws Exception {
        Map<String, Parser> parsers = this.getConcreteParsers(config.getParser());
        Element parsersElement = doc.createElement("parsers");
        rootElement.appendChild(parsersElement);
        ParseContext context = new ParseContext();
        for (Map.Entry<String, Parser> e : parsers.entrySet()) {
            Element parserElement = doc.createElement("parser");
            Parser child = e.getValue();
            String className = e.getKey();
            parserElement.setAttribute("class", className);
            TreeSet types = new TreeSet();
            types.addAll(child.getSupportedTypes(context));
            for (MediaType type : types) {
                Element mimeElement = doc.createElement("mime");
                mimeElement.appendChild(doc.createTextNode(type.toString()));
                parserElement.appendChild(mimeElement);
            }
            parsersElement.appendChild(parserElement);
        }
        rootElement.appendChild(parsersElement);
    }

    private Map<String, Parser> getConcreteParsers(Parser parentParser) throws TikaException, IOException {
        TreeMap<String, Parser> parsers = new TreeMap<String, Parser>();
        if (parentParser instanceof CompositeParser) {
            this.addParsers((CompositeParser)parentParser, parsers);
        } else {
            this.addParser(parentParser, parsers);
        }
        return parsers;
    }

    private void addParsers(CompositeParser p, Map<String, Parser> parsers) {
        for (Parser child : p.getParsers().values()) {
            if (child instanceof CompositeParser) {
                this.addParsers((CompositeParser)child, parsers);
                continue;
            }
            this.addParser(child, parsers);
        }
    }

    private void addParser(Parser p, Map<String, Parser> parsers) {
        parsers.put(p.getClass().getCanonicalName(), p);
    }

    public static void main(String[] args) throws Exception {
        String encoding = "UTF-8";
        Writer writer = null;
        writer = args.length > 0 ? new OutputStreamWriter(new FileOutputStream(new File(args[0]))) : new StringWriter();
        if (args.length > 1) {
            encoding = args[1];
        }
        DumpTikaConfigExample ex = new DumpTikaConfigExample();
        ex.dump(TikaConfig.getDefaultConfig(), writer, encoding);
        writer.flush();
        if (writer instanceof StringWriter) {
            System.out.println(writer.toString());
        }
        writer.close();
    }
}

