/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.EnumSet;
import org.apache.hadoop.util.ProgramDriver;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.mapreduce.examples.BroadcastAndOneToOneExample;
import org.apache.tez.mapreduce.examples.FilterLinesByWord;
import org.apache.tez.mapreduce.examples.FilterLinesByWordOneToOne;
import org.apache.tez.mapreduce.examples.GroupByOrderByMRRTest;
import org.apache.tez.mapreduce.examples.Join;
import org.apache.tez.mapreduce.examples.MRRSleepJob;
import org.apache.tez.mapreduce.examples.MapredWordCount;
import org.apache.tez.mapreduce.examples.RPCLoadGen;
import org.apache.tez.mapreduce.examples.RandomTextWriter;
import org.apache.tez.mapreduce.examples.RandomWriter;
import org.apache.tez.mapreduce.examples.SecondarySort;
import org.apache.tez.mapreduce.examples.Sort;
import org.apache.tez.mapreduce.examples.TestOrderedWordCount;
import org.apache.tez.mapreduce.examples.UnionExample;

public class ExampleDriver {
    private static final DecimalFormat formatter = new DecimalFormat("###.##%");

    public static void main(String[] argv) {
        int exitCode = -1;
        ProgramDriver pgd = new ProgramDriver();
        try {
            pgd.addClass("rpcloadgen", RPCLoadGen.class, "Run a DAG to generate load for the task to AM RPC");
            pgd.addClass("wordcount", MapredWordCount.class, "A map/reduce program that counts the words in the input files.");
            pgd.addClass("mapredwordcount", MapredWordCount.class, "A map/reduce program that counts the words in the input files using the mapred apis.");
            pgd.addClass("randomwriter", RandomWriter.class, "A map/reduce program that writes 10GB of random data per node.");
            pgd.addClass("randomtextwriter", RandomTextWriter.class, "A map/reduce program that writes 10GB of random textual data per node.");
            pgd.addClass("sort", Sort.class, "A map/reduce program that sorts the data written by the random writer.");
            pgd.addClass("secondarysort", SecondarySort.class, "An example defining a secondary sort to the reduce.");
            pgd.addClass("join", Join.class, "A job that effects a join over sorted, equally partitioned datasets");
            pgd.addClass("groupbyorderbymrrtest", GroupByOrderByMRRTest.class, "A map-reduce-reduce program that does groupby-order by. Takes input containing employee_name department name per line of input and generates count of employees per department and sorted on employee count");
            pgd.addClass("mrrsleep", MRRSleepJob.class, "MRR Sleep Job");
            pgd.addClass("testorderedwordcount", TestOrderedWordCount.class, "Word Count with words sorted on frequency");
            pgd.addClass("unionexample", UnionExample.class, "Union example");
            pgd.addClass("broadcastAndOneToOneExample", BroadcastAndOneToOneExample.class, "BroadcastAndOneToOneExample example");
            pgd.addClass("filterLinesByWord", FilterLinesByWord.class, "Filters lines by the specified word using broadcast edge");
            pgd.addClass("filterLinesByWordOneToOne", FilterLinesByWordOneToOne.class, "Filters lines by the specified word using OneToOne edge");
            exitCode = pgd.run(argv);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.exit(exitCode);
    }

    public static void printDAGStatus(DAGClient dagClient, String[] vertexNames) throws IOException, TezException {
        ExampleDriver.printDAGStatus(dagClient, vertexNames, false, false);
    }

    public static void printDAGStatus(DAGClient dagClient, String[] vertexNames, boolean displayDAGCounters, boolean displayVertexCounters) throws IOException, TezException {
        TezCounters counters;
        EnumSet<StatusGetOpts> opts = EnumSet.of(StatusGetOpts.GET_COUNTERS);
        DAGStatus dagStatus = dagClient.getDAGStatus(displayDAGCounters ? opts : null);
        Progress progress = dagStatus.getDAGProgress();
        double vProgressFloat = 0.0;
        if (progress != null) {
            System.out.println("");
            System.out.println("DAG: State: " + dagStatus.getState() + " Progress: " + (progress.getTotalTaskCount() < 0 ? formatter.format(0.0) : formatter.format((double)progress.getSucceededTaskCount() / (double)progress.getTotalTaskCount())));
            for (String vertexName : vertexNames) {
                TezCounters counters2;
                VertexStatus vStatus = dagClient.getVertexStatus(vertexName, displayVertexCounters ? opts : null);
                if (vStatus == null) {
                    System.out.println("Could not retrieve status for vertex: " + vertexName);
                    continue;
                }
                Progress vProgress = vStatus.getProgress();
                if (vProgress != null) {
                    vProgressFloat = 0.0;
                    if (vProgress.getTotalTaskCount() == 0) {
                        vProgressFloat = 1.0;
                    } else if (vProgress.getTotalTaskCount() > 0) {
                        vProgressFloat = (double)vProgress.getSucceededTaskCount() / (double)vProgress.getTotalTaskCount();
                    }
                    System.out.println("VertexStatus: VertexName: " + (vertexName.equals("ivertex1") ? "intermediate-reducer" : vertexName) + " Progress: " + formatter.format(vProgressFloat));
                }
                if (!displayVertexCounters || (counters2 = vStatus.getVertexCounters()) == null) continue;
                System.out.println("Vertex Counters for " + vertexName + ": " + counters2);
            }
        }
        if (displayDAGCounters && (counters = dagStatus.getDAGCounters()) != null) {
            System.out.println("DAG Counters: " + counters);
        }
    }
}

